/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import com.github.loki4j.client.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LabelsPatternParser {
    public static final String KV_REGEX_STARTER = "regex:";
    public static final Pattern BULK_PATTERN_KEY_REGEX = Pattern.compile("^(.*)\\*[ ]*(!)?$");
    public static final Pattern BULK_PATTERN_VALUE_REGEX = Pattern.compile("^%%([^{]+)(\\{([^}]*)\\})?$");

    public static List<Map.Entry<String, String>> extractKVPairsFromPattern(String pattern, String pairSeparator, String keyValueSeparator) {
        Pattern pairSeparatorPattern = pairSeparator.startsWith(KV_REGEX_STARTER) ? Pattern.compile(pairSeparator.substring(KV_REGEX_STARTER.length())) : Pattern.compile(Pattern.quote(pairSeparator));
        Pattern keyValueSeparatorPattern = Pattern.compile(Pattern.quote(keyValueSeparator));
        String[] pairs = pairSeparatorPattern.split(pattern);
        ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
        for (int i = 0; i < pairs.length; ++i) {
            if (StringUtils.isBlank(pairs[i])) continue;
            String[] kv = keyValueSeparatorPattern.split(pairs[i]);
            if (kv.length == 2) {
                result.add(Map.entry(kv[0].trim(), kv[1].trim()));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unable to split '%s' in '%s' to key-value pairs, pairSeparator=%s, keyValueSeparator=%s", pairs[i], pattern, pairSeparator, keyValueSeparator));
        }
        if (result.isEmpty()) {
            throw new IllegalArgumentException("Empty of blank patterns are not supported");
        }
        return result;
    }

    public static boolean isBulkPattern(Map.Entry<String, String> kvp) {
        return kvp.getValue().startsWith("%%") && kvp.getKey().contains("*");
    }

    public static BulkPattern parseBulkPattern(String key, String value) {
        Matcher keyMatch = BULK_PATTERN_KEY_REGEX.matcher(key);
        if (!keyMatch.find()) {
            throw new IllegalArgumentException("Unable to parse bulk pattern key: " + key);
        }
        String prefix = keyMatch.group(1).trim();
        boolean neg = keyMatch.group(2) != null;
        Matcher valueMatch = BULK_PATTERN_VALUE_REGEX.matcher(value);
        if (!valueMatch.find()) {
            throw new IllegalArgumentException("Unable to parse bulk pattern value: " + value);
        }
        String func = valueMatch.group(1).trim();
        String paramsStr = valueMatch.group(3);
        Set<String> params = paramsStr != null && !paramsStr.isBlank() ? Arrays.stream(valueMatch.group(3).split(",")).map(String::trim).collect(Collectors.toSet()) : Set.of();
        Set<String> include = !neg ? params : Set.of();
        Set<String> exclude = neg ? params : Set.of();
        return new BulkPattern(prefix, func, include, exclude);
    }

    public static class BulkPattern {
        public String prefix;
        public String func;
        public Set<String> include;
        public Set<String> exclude;

        public BulkPattern(String prefix, String func, Set<String> include, Set<String> exclude) {
            this.prefix = prefix;
            this.func = func;
            this.include = include;
            this.exclude = exclude;
        }

        public String toString() {
            return "BulkPattern [prefix=" + this.prefix + ", func=" + this.func + ", include=" + String.valueOf(this.include) + ", exclude=" + String.valueOf(this.exclude) + "]";
        }
    }
}

