/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.status.StatusListener;
import com.github.loki4j.client.batch.LogRecord;
import com.github.loki4j.client.pipeline.AsyncBufferPipeline;
import com.github.loki4j.client.pipeline.PipelineConfig;
import com.github.loki4j.logback.LabelsPatternParser;
import com.github.loki4j.logback.PipelineConfigAppenderBase;
import com.github.loki4j.logback.StatusPrinter;
import com.github.loki4j.logback.extractor.Extractor;
import com.github.loki4j.logback.extractor.MarkerExtractor;
import com.github.loki4j.logback.extractor.MetadataExtractor;
import com.github.loki4j.logback.extractor.PatternsExtractor;
import com.github.loki4j.slf4j.marker.AbstractKeyValueMarker;
import com.github.loki4j.slf4j.marker.LabelMarker;
import com.github.loki4j.slf4j.marker.StructuredMetadataMarker;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class Loki4jAppender
extends PipelineConfigAppenderBase {
    private static final String KV_PAIR_SEPARATOR = "regex:\n|\r";
    private static final String KV_KV_SEPARATOR = "=";
    private static final String DEFAULT_LBL_PATTERN = "agent=loki4j\napp=%s\nhost=%s";
    private static final String DEFAULT_SMD_PATTERN = "level=%level\nthread=%thread\nlogger=%logger\n*=%%mdc\n*=%%kvp";
    private static final String DEFAULT_MSG_PATTERN = "[%thread] %logger{20} - %msg%n";
    public static final String DISABLE_SMD_PATTERN = "off";
    private String labelsPattern;
    private String structuredMetadataPattern;
    private Layout<ILoggingEvent> messageLayout;
    private boolean readMarkers = false;
    private boolean verbose = false;
    private AsyncBufferPipeline pipeline;
    private AtomicLong droppedEventsCount = new AtomicLong(0L);
    private List<Extractor> labelValueExtractors = new ArrayList<Extractor>();
    private List<Extractor> metadataValueExtractors = new ArrayList<Extractor>();
    private Map<String, String> staticLabelStream = null;

    public void start() {
        if (this.getStatusManager() != null && this.getStatusManager().getCopyOfStatusListenerList().isEmpty()) {
            StatusPrinter statusListener = new StatusPrinter(this.verbose ? 0 : 1);
            statusListener.setContext(this.getContext());
            statusListener.start();
            this.getStatusManager().add((StatusListener)statusListener);
        }
        if (this.labelsPattern == null) {
            this.labelsPattern = String.format(DEFAULT_LBL_PATTERN, this.context.getProperty("CONTEXT_NAME"), this.context.getProperty("HOSTNAME"));
        }
        this.labelValueExtractors = this.initExtractors(this.labelsPattern, LabelMarker.class);
        if (this.structuredMetadataPattern == null) {
            this.structuredMetadataPattern = DEFAULT_SMD_PATTERN;
        }
        if (!this.structuredMetadataPattern.isBlank() && !this.structuredMetadataPattern.equalsIgnoreCase(DISABLE_SMD_PATTERN)) {
            this.metadataValueExtractors = this.initExtractors(this.structuredMetadataPattern, StructuredMetadataMarker.class);
        }
        if (this.messageLayout == null) {
            this.addWarn("No message layout specified in the config. Using PatternLayout with default settings");
            this.messageLayout = this.initPatternLayout(DEFAULT_MSG_PATTERN);
        }
        this.messageLayout.setContext(this.context);
        this.messageLayout.start();
        PipelineConfig pipelineConf = this.buildPipelineConfig();
        this.pipeline = new AsyncBufferPipeline(pipelineConf);
        this.pipeline.start();
        super.start();
        this.addInfo("Successfully started");
    }

    public void stop() {
        if (!super.isStarted()) {
            return;
        }
        this.addInfo("Stopping...");
        super.stop();
        this.pipeline.stop();
        this.messageLayout.stop();
        this.addInfo("Successfully stopped");
    }

    protected void append(ILoggingEvent event) {
        boolean appended = this.pipeline.append(() -> this.eventToLogRecord(event));
        if (!appended) {
            this.reportDroppedEvents();
        }
    }

    public LogRecord eventToLogRecord(ILoggingEvent event) {
        return LogRecord.create(event.getTimeStamp(), event.getNanoseconds() % 1000000, this.extractStream(event), this.extractMessage(event), this.extractMetadata(event));
    }

    private Map<String, String> extractStream(ILoggingEvent e) {
        if (this.isStaticLabels()) {
            if (this.staticLabelStream == null) {
                if (this.labelValueExtractors.size() == 1) {
                    LinkedHashMap<String, String> kvs = new LinkedHashMap<String, String>();
                    this.labelValueExtractors.get(0).extract(e, kvs);
                    this.staticLabelStream = kvs;
                } else {
                    throw new IllegalStateException("No bulk patterns allowed for static label configuration");
                }
            }
            return this.staticLabelStream;
        }
        LinkedHashMap<String, String> kvs = new LinkedHashMap<String, String>();
        for (Extractor extractor : this.labelValueExtractors) {
            extractor.extract(e, kvs);
        }
        return kvs;
    }

    private Map<String, String> extractMetadata(ILoggingEvent e) {
        if (this.metadataValueExtractors.isEmpty()) {
            return Map.of();
        }
        LinkedHashMap<String, String> kvs = new LinkedHashMap<String, String>();
        for (Extractor extractor : this.metadataValueExtractors) {
            extractor.extract(e, kvs);
        }
        return kvs;
    }

    private String extractMessage(ILoggingEvent e) {
        return this.messageLayout.doLayout((Object)e);
    }

    private PatternLayout initPatternLayout(String pattern) {
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setPattern(pattern);
        return patternLayout;
    }

    private void reportDroppedEvents() {
        long dropped = this.droppedEventsCount.incrementAndGet();
        if (dropped == 1L || dropped <= 90L && dropped % 20L == 0L || dropped <= 900L && dropped % 100L == 0L || dropped <= 900000L && dropped % 1000L == 0L || dropped <= 9000000L && dropped % 10000L == 0L || dropped <= 900000000L && dropped % 1000000L == 0L || dropped > 1000000000L) {
            this.addWarn(String.format("Backpressure: %s messages dropped. Check `sendQueueSizeBytes` setting", dropped));
            if (dropped > 1000000000L) {
                this.addWarn(String.format("Resetting dropped message counter from %s to 0", dropped));
                this.droppedEventsCount.set(0L);
            }
        }
    }

    private <T extends AbstractKeyValueMarker> List<Extractor> initExtractors(String pattern, Class<T> markerClass) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        List<Map.Entry<String, String>> kvPairs = LabelsPatternParser.extractKVPairsFromPattern(pattern, KV_PAIR_SEPARATOR, KV_KV_SEPARATOR);
        LinkedHashMap<String, String> logbackPatterns = new LinkedHashMap<String, String>();
        kvPairs.stream().filter(e -> !LabelsPatternParser.isBulkPattern(e)).forEach(e -> logbackPatterns.put((String)e.getKey(), (String)e.getValue()));
        try {
            extractors.add(new PatternsExtractor(logbackPatterns, this.context));
        }
        catch (ScanException e2) {
            throw new IllegalArgumentException("Unable to parse pattern: \"" + pattern + "\"", e2);
        }
        List bulkPatterns = kvPairs.stream().filter(LabelsPatternParser::isBulkPattern).collect(Collectors.toList());
        for (Map.Entry bulkPattern : bulkPatterns) {
            LabelsPatternParser.BulkPattern parsed = LabelsPatternParser.parseBulkPattern((String)bulkPattern.getKey(), (String)bulkPattern.getValue());
            if (parsed.func.equalsIgnoreCase("mdc")) {
                extractors.add(MetadataExtractor.mdc(parsed.prefix, parsed.include, parsed.exclude));
                continue;
            }
            if (parsed.func.equalsIgnoreCase("kvp")) {
                extractors.add(MetadataExtractor.kvp(parsed.prefix, parsed.include, parsed.exclude));
                continue;
            }
            throw new IllegalArgumentException(String.format("Unknown function '%s' used for bulk pattern: %s", parsed.func, bulkPattern.getValue()));
        }
        if (this.readMarkers) {
            extractors.add(new MarkerExtractor<T>(markerClass));
        }
        return extractors;
    }

    void waitSendQueueIsEmpty(long timeoutMs) {
        this.pipeline.waitPipelineIsEmpty(timeoutMs);
    }

    long droppedEventsCount() {
        return this.droppedEventsCount.get();
    }

    public void setLabels(String labelsPattern) {
        this.labelsPattern = labelsPattern;
    }

    public void setStructuredMetadata(String structuredMetadataPattern) {
        this.structuredMetadataPattern = structuredMetadataPattern;
    }

    @DefaultClass(value=PatternLayout.class)
    public void setMessage(Layout<ILoggingEvent> messageLayout) {
        this.messageLayout = messageLayout;
    }

    public void setReadMarkers(boolean readMarkers) {
        this.readMarkers = readMarkers;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

