/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.joran.spi.DefaultClass;
import ch.qos.logback.core.spi.ContextAware;
import com.github.loki4j.client.http.HttpConfig;
import com.github.loki4j.client.pipeline.PipelineConfig;
import com.github.loki4j.logback.HttpSender;
import com.github.loki4j.logback.InternalLogger;
import com.github.loki4j.logback.JavaHttpSender;
import java.util.Optional;

public abstract class PipelineConfigAppenderBase
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private BatchCfg batch = new BatchCfg();
    private HttpCfg http = new HttpCfg();
    private boolean metricsEnabled = false;

    protected boolean isStaticLabels() {
        return this.batch.staticLabels;
    }

    protected PipelineConfig buildPipelineConfig() {
        HttpSender effectiveSender;
        PipelineConfig.WriterFactory effectiveWriter;
        this.addInfo(String.format("Starting with batchMaxItems=%s, batchMaxBytes=%s, batchTimeout=%s, sendQueueMaxBytes=%s...", this.batch.maxItems, this.batch.maxBytes, this.batch.timeoutMs, this.batch.sendQueueMaxBytes));
        long effectiveSendQueueMaxBytes = this.batch.sendQueueMaxBytes;
        if (effectiveSendQueueMaxBytes < (long)(this.batch.maxBytes * 5)) {
            this.addWarn("Configured value sendQueueMaxBytes=" + effectiveSendQueueMaxBytes + " is less than `batchMaxBytes * 5`");
            effectiveSendQueueMaxBytes = this.batch.maxBytes * 5;
        }
        if ((effectiveWriter = this.http.writer) == null) {
            PipelineConfig.WriterFactory writerFactory = effectiveWriter = this.http.useProtobufApi ? PipelineConfig.protobuf : PipelineConfig.json;
        }
        if ((effectiveSender = this.http.sender) == null) {
            effectiveSender = new JavaHttpSender();
        }
        return PipelineConfig.builder().setName(this.getName() == null ? "none" : this.getName()).setBatchMaxItems(this.batch.maxItems).setBatchMaxBytes(this.batch.maxBytes).setBatchTimeoutMs(this.batch.timeoutMs).setStaticLabels(this.batch.staticLabels).setSendQueueMaxBytes(effectiveSendQueueMaxBytes).setInternalQueuesCheckTimeoutMs(this.batch.internalQueuesCheckTimeoutMs).setUseDirectBuffers(this.batch.useDirectBuffers).setDrainOnStop(this.batch.drainOnStop).setMaxRetries(this.http.maxRetries).setMinRetryBackoffMs(this.http.minRetryBackoffMs).setMaxRetryBackoffMs(this.http.maxRetryBackoffMs).setMaxRetryJitterMs(this.http.maxRetryJitterMs).setDropRateLimitedBatches(this.http.dropRateLimitedBatches).setMetricsEnabled(this.metricsEnabled).setWriter(effectiveWriter).setHttpConfig(effectiveSender.getConfig().fill(this::fillHttpConfig)).setHttpClientFactory(effectiveSender.getHttpClientFactory()).setInternalLoggingFactory(source -> new InternalLogger(source, (ContextAware)this)).build();
    }

    private void fillHttpConfig(HttpConfig.Builder builder) {
        builder.setPushUrl(this.http.url).setTenantId(this.http.tenantId).setConnectionTimeoutMs(this.http.connectionTimeoutMs).setRequestTimeoutMs(this.http.requestTimeoutMs).setUsername(Optional.ofNullable(this.http.auth).map(a -> a.username)).setPassword(Optional.ofNullable(this.http.auth).map(a -> a.password));
    }

    BatchCfg getBatch() {
        return this.batch;
    }

    public void setBatch(BatchCfg batch) {
        this.batch = batch;
    }

    HttpCfg getHttp() {
        return this.http;
    }

    public void setHttp(HttpCfg http) {
        this.http = http;
    }

    public void setMetricsEnabled(boolean metricsEnabled) {
        this.metricsEnabled = metricsEnabled;
    }

    public static final class BasicAuth {
        String username;
        String password;

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static final class HttpCfg {
        private String url = "http://localhost:3100/loki/api/v1/push";
        private Optional<String> tenantId = Optional.empty();
        private long connectionTimeoutMs = 30000L;
        private long requestTimeoutMs = 5000L;
        private BasicAuth auth;
        int maxRetries = 2;
        long minRetryBackoffMs = 500L;
        long maxRetryBackoffMs = 60000L;
        int maxRetryJitterMs = 500;
        boolean dropRateLimitedBatches = false;
        boolean useProtobufApi = false;
        private PipelineConfig.WriterFactory writer;
        private HttpSender sender;

        public void setUrl(String url) {
            this.url = url;
        }

        public void setAuth(BasicAuth auth) {
            this.auth = auth;
        }

        public void setTenantId(String tenant) {
            this.tenantId = Optional.ofNullable(tenant);
        }

        public void setConnectionTimeoutMs(long connectionTimeoutMs) {
            this.connectionTimeoutMs = connectionTimeoutMs;
        }

        public void setRequestTimeoutMs(long requestTimeoutMs) {
            this.requestTimeoutMs = requestTimeoutMs;
        }

        public void setMaxRetries(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public void setMinRetryBackoffMs(long minRetryBackoffMs) {
            this.minRetryBackoffMs = minRetryBackoffMs;
        }

        public void setMaxRetryBackoffMs(long maxRetryBackoffMs) {
            this.maxRetryBackoffMs = maxRetryBackoffMs;
        }

        public void setMaxRetryJitterMs(int maxRetryJitterMs) {
            this.maxRetryJitterMs = maxRetryJitterMs;
        }

        public void setDropRateLimitedBatches(boolean dropRateLimitedBatches) {
            this.dropRateLimitedBatches = dropRateLimitedBatches;
        }

        public void setUseProtobufApi(boolean useProtobufApi) {
            this.useProtobufApi = useProtobufApi;
        }

        @DefaultClass(value=JavaHttpSender.class)
        public void setSender(HttpSender sender) {
            this.sender = sender;
        }

        void setWriter(PipelineConfig.WriterFactory writer) {
            this.writer = writer;
        }
    }

    public static final class BatchCfg {
        int maxItems = 1000;
        int maxBytes = 0x400000;
        long timeoutMs = 60000L;
        long sendQueueMaxBytes = this.maxBytes * 10;
        long internalQueuesCheckTimeoutMs = 25L;
        boolean drainOnStop = true;
        boolean useDirectBuffers = true;
        boolean staticLabels = false;

        public void setMaxItems(int maxItems) {
            this.maxItems = maxItems;
        }

        public void setMaxBytes(int maxBytes) {
            this.maxBytes = maxBytes;
        }

        public void setTimeoutMs(long timeoutMs) {
            this.timeoutMs = timeoutMs;
        }

        public void setSendQueueMaxBytes(long sendQueueMaxBytes) {
            this.sendQueueMaxBytes = sendQueueMaxBytes;
        }

        public void setInternalQueuesCheckTimeoutMs(long internalQueuesCheckTimeoutMs) {
            this.internalQueuesCheckTimeoutMs = internalQueuesCheckTimeoutMs;
        }

        public void setDrainOnStop(boolean drainOnStop) {
            this.drainOnStop = drainOnStop;
        }

        public void setUseDirectBuffers(boolean useDirectBuffers) {
            this.useDirectBuffers = useDirectBuffers;
        }

        public void setStaticLabels(boolean staticLabels) {
            this.staticLabels = staticLabels;
        }
    }
}

