/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.extractor;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.github.loki4j.logback.extractor.Extractor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.event.KeyValuePair;

public abstract class MetadataExtractor<E, T extends Collection<E>>
implements Extractor {
    private final String prefix;
    private final boolean noPrefix;
    private Set<String> excludeKeys = new HashSet<String>();
    private Set<String> includeKeys = new HashSet<String>();

    MetadataExtractor(String prefix, Set<String> includeKeys, Set<String> excludeKeys) {
        this.prefix = prefix;
        this.noPrefix = prefix == null || prefix.length() == 0;
        this.excludeKeys = excludeKeys;
        this.includeKeys = includeKeys;
    }

    @Override
    public void extract(ILoggingEvent event, Map<String, String> result) {
        T entries = this.extractEntries(event);
        if (entries == null || entries.isEmpty()) {
            return;
        }
        for (Object entry : entries) {
            String key = this.extractKey(entry);
            String value = this.extractValue(entry);
            if (key == null || value == null || !this.excludeKeys.isEmpty() && this.excludeKeys.contains(key) || !this.includeKeys.isEmpty() && !this.includeKeys.contains(key)) continue;
            result.put((String)(this.noPrefix ? key : this.prefix + key), value);
        }
    }

    public static MdcBulkPatternExtractor mdc(String prefix, Set<String> excludeKeys, Set<String> includeKeys) {
        return new MdcBulkPatternExtractor(prefix, excludeKeys, includeKeys);
    }

    public static KvpBulkPatternExtractor kvp(String prefix, Set<String> excludeKeys, Set<String> includeKeys) {
        return new KvpBulkPatternExtractor(prefix, excludeKeys, includeKeys);
    }

    protected abstract T extractEntries(ILoggingEvent var1);

    protected abstract String extractKey(E var1);

    protected abstract String extractValue(E var1);

    public static class KvpBulkPatternExtractor
    extends MetadataExtractor<KeyValuePair, List<KeyValuePair>> {
        KvpBulkPatternExtractor(String prefix, Set<String> excludeKeys, Set<String> includeKeys) {
            super(prefix, excludeKeys, includeKeys);
        }

        @Override
        protected List<KeyValuePair> extractEntries(ILoggingEvent event) {
            return event.getKeyValuePairs();
        }

        @Override
        protected String extractKey(KeyValuePair entry) {
            return entry.key;
        }

        @Override
        protected String extractValue(KeyValuePair entry) {
            return entry.value == null ? null : entry.value.toString();
        }
    }

    public static class MdcBulkPatternExtractor
    extends MetadataExtractor<Map.Entry<String, String>, Set<Map.Entry<String, String>>> {
        MdcBulkPatternExtractor(String prefix, Set<String> excludeKeys, Set<String> includeKeys) {
            super(prefix, excludeKeys, includeKeys);
        }

        @Override
        protected Set<Map.Entry<String, String>> extractEntries(ILoggingEvent event) {
            Map mdcProperties = event.getMDCPropertyMap();
            return mdcProperties == null ? null : mdcProperties.entrySet();
        }

        @Override
        protected String extractKey(Map.Entry<String, String> entry) {
            return entry.getKey();
        }

        @Override
        protected String extractValue(Map.Entry<String, String> entry) {
            return entry.getValue();
        }
    }
}

