/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.extractor;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.ConverterUtil;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import ch.qos.logback.core.spi.ScanException;
import com.github.loki4j.logback.extractor.Extractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PatternsExtractor
implements Extractor {
    private static final int INITIAL_STRING_BUILDER_SIZE = 64;
    private final List<String> keys;
    private final List<Converter<ILoggingEvent>> converters = new ArrayList<Converter<ILoggingEvent>>();

    public PatternsExtractor(Map<String, String> patterns, Context context) throws ScanException {
        this.keys = List.copyOf(patterns.keySet());
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext(context);
        Map effectiveConverterMap = patternLayout.getEffectiveConverterMap();
        for (String pattern : patterns.values()) {
            try {
                Parser p = new Parser(pattern);
                if (context != null) {
                    p.setContext(context);
                }
                Node t = p.parse();
                Converter converter = p.compile(t, effectiveConverterMap);
                ConverterUtil.setContextForConverters((Context)context, (Converter)converter);
                ConverterUtil.startConverters((Converter)converter);
                this.converters.add((Converter<ILoggingEvent>)converter);
            }
            catch (ScanException sce) {
                throw new ScanException("Unable to parse pattern: \"" + pattern + "\"", (Throwable)sce);
            }
        }
    }

    @Override
    public void extract(ILoggingEvent event, Map<String, String> result) {
        StringBuilder strBuilder = new StringBuilder(64);
        for (int i = 0; i < this.converters.size(); ++i) {
            for (Converter c = this.converters.get(i); c != null; c = c.getNext()) {
                c.write(strBuilder, (Object)event);
            }
            result.put(this.keys.get(i), strBuilder.toString());
            strBuilder.setLength(0);
        }
    }
}

