/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.json;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.github.loki4j.logback.json.AbstractJsonProvider;
import com.github.loki4j.logback.json.JsonEventWriter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractFieldCollectionJsonProvider<V, E, T extends Collection<E>>
extends AbstractJsonProvider {
    private String prefix;
    private boolean noPrefix;
    private Set<String> excludeKeys = new HashSet<String>();
    private Set<String> includeKeys = new HashSet<String>();

    @Override
    public boolean canWrite(ILoggingEvent event) {
        T entries = this.extractEntries(event);
        return entries != null && !entries.isEmpty();
    }

    @Override
    public boolean writeTo(JsonEventWriter writer, ILoggingEvent event, boolean startWithSeparator) {
        T entries = this.extractEntries(event);
        boolean firstFieldWritten = false;
        for (Object entry : entries) {
            String key = this.extractKey(entry);
            V value = this.extractValue(entry);
            if (key == null || value == null || !this.excludeKeys.isEmpty() && this.excludeKeys.contains(key) || !this.includeKeys.isEmpty() && !this.includeKeys.contains(key)) continue;
            if (startWithSeparator || firstFieldWritten) {
                writer.writeFieldSeparator();
            }
            String name = this.noPrefix ? key : this.prefix + key;
            this.writeField(writer, name, value);
            firstFieldWritten = true;
        }
        return firstFieldWritten;
    }

    protected abstract T extractEntries(ILoggingEvent var1);

    protected abstract String extractKey(E var1);

    protected abstract V extractValue(E var1);

    protected abstract void writeField(JsonEventWriter var1, String var2, V var3);

    public void addExclude(String key) {
        this.excludeKeys.add(key);
    }

    public void addInclude(String key) {
        this.includeKeys.add(key);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isNoPrefix() {
        return this.noPrefix;
    }

    public void setNoPrefix(boolean noPrefix) {
        this.noPrefix = noPrefix;
    }
}

