/*
 * Decompiled with CFR 0.152.
 */
package com.github.loki4j.logback.json;

import ch.qos.logback.classic.pattern.Abbreviator;
import ch.qos.logback.classic.pattern.ClassNameOnlyAbbreviator;
import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import com.github.loki4j.logback.json.AbstractFieldJsonProvider;
import com.github.loki4j.logback.json.JsonEventWriter;

public class LoggerNameJsonProvider
extends AbstractFieldJsonProvider {
    public static final String FIELD_LOGGER_NAME = "logger_name";
    private int targetLength = -1;
    private Abbreviator abbreviator;

    public LoggerNameJsonProvider() {
        this.setFieldName(FIELD_LOGGER_NAME);
    }

    @Override
    public void start() {
        super.start();
        this.abbreviator = this.targetLength > 0 ? new TargetLengthBasedClassNameAbbreviator(this.targetLength) : (this.targetLength == 0 ? new ClassNameOnlyAbbreviator() : new NoOpAbbreviator());
    }

    @Override
    public void stop() {
        this.abbreviator = null;
        super.stop();
    }

    @Override
    protected void writeExactlyOneField(JsonEventWriter writer, ILoggingEvent event) {
        writer.writeStringField(this.getFieldName(), this.abbreviator.abbreviate(event.getLoggerName()));
    }

    public void setTargetLength(int targetLength) {
        this.targetLength = targetLength;
    }

    public static class NoOpAbbreviator
    implements Abbreviator {
        public String abbreviate(String in) {
            return in;
        }
    }
}

