/*
 * Decompiled with CFR 0.152.
 */
package com.github.lsiu.maven.plugin.websphere;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.codehaus.plexus.util.cli.StreamPumper;

@Mojo(name="create-ejb-stubs", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST)
public class CreateEjbStubsMojo
extends AbstractMojo {
    @Parameter(defaultValue="/IBM/WebSphere/AppServer", property="websphereHome", required=true)
    private File websphereHome;
    @Parameter(property="class")
    private String[] classes;
    @Parameter(property="inputFile")
    private File inputFile;
    @Parameter(defaultValue="${project.build.outputDirectory}", property="outputDirectory")
    private File outputDirectory;
    @Parameter(property="updateFile")
    private File updateFile;
    @Parameter(property="filesets")
    private List<FileSet> filesets;
    @Parameter(required=true, readonly=true, property="project.testClasspathElements")
    protected List<String> classpath;

    public void execute() throws MojoExecutionException {
        boolean isDirMade;
        if (this.websphereHome == null) {
            throw new MojoExecutionException("Missing <websphereHome> configuration");
        }
        if (!this.websphereHome.exists()) {
            throw new MojoExecutionException("Directory specified in <websphereHome> '" + this.websphereHome.getAbsolutePath() + "' not found");
        }
        if (!this.websphereHome.isDirectory()) {
            throw new MojoExecutionException("Value specified in <websphereHome> '" + this.websphereHome.getAbsolutePath() + "' is not a directory");
        }
        if (this.outputDirectory == null) {
            throw new MojoExecutionException("Output Directory cannot be null");
        }
        if (!this.outputDirectory.exists() && !(isDirMade = this.outputDirectory.mkdirs())) {
            throw new MojoExecutionException(String.format("Cannot create output directory '%s'", this.outputDirectory));
        }
        if (this.inputFile != null) {
            this.createEjbStubsForInputFile();
        } else if (this.classes != null && this.classes.length > 0) {
            this.createEjbStubsForClasses();
        } else if (this.filesets != null && this.filesets.size() > 0) {
            this.createEjbStubsForClassesSet();
        } else {
            throw new MojoExecutionException("Must specify <inputFile> or at least one <class> in configuration");
        }
    }

    private void createEjbStubsForClasses() throws MojoExecutionException {
        String[] command = new String[4];
        command[0] = new File(this.websphereHome, CreateEjbStubsMojo.getExecutable()).getAbsolutePath();
        command[2] = "-cp";
        command[3] = StringUtils.join((Object[])this.classpath.toArray(), (String)File.pathSeparator);
        String[] stringArray = this.classes;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String clazz;
            command[1] = clazz = stringArray[i];
            this.executeCreateEjbStubs(command);
        }
    }

    private void createEjbStubsForClassesSet() throws MojoExecutionException {
        FileSetManager fileSetManager = new FileSetManager();
        String[] command = new String[4];
        command[0] = new File(this.websphereHome, CreateEjbStubsMojo.getExecutable()).getAbsolutePath();
        command[2] = "-cp";
        command[3] = StringUtils.join((Object[])this.classpath.toArray(), (String)File.pathSeparator);
        for (FileSet fileset : this.filesets) {
            String[] includedFiles;
            for (String clazz : includedFiles = fileSetManager.getIncludedFiles(fileset)) {
                clazz = FilenameUtils.removeExtension((String)clazz);
                command[1] = clazz.replace(File.separator, ".");
                this.executeCreateEjbStubs(command);
            }
        }
    }

    private void createEjbStubsForInputFile() throws MojoExecutionException {
        String[] command;
        if (!this.inputFile.exists()) {
            throw new MojoExecutionException("File specified in <inputFile> '" + this.inputFile.getAbsolutePath() + "' not found");
        }
        if (this.updateFile != null) {
            if (!this.updateFile.exists()) {
                throw new MojoExecutionException("File specified in <updateFile> '" + this.updateFile.getAbsolutePath() + "' not found");
            }
            command = new String[6];
            command[4] = "-updatefile";
            command[5] = this.updateFile.getAbsolutePath();
        } else {
            command = new String[]{new File(this.websphereHome, CreateEjbStubsMojo.getExecutable()).getAbsolutePath(), this.inputFile.getAbsolutePath(), "-cp", StringUtils.join((Object[])this.classpath.toArray(), (String)File.pathSeparator)};
        }
        this.executeCreateEjbStubs(command);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void executeCreateEjbStubs(String[] command) throws MojoExecutionException {
        try {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().info((CharSequence)StringUtils.join((Object[])command, (String)" "));
            }
            Process p = null;
            int retry = 0;
            boolean cmdSuccess = false;
            while (true) {
                if (cmdSuccess) return;
                try {
                    p = new ProcessBuilder(new String[0]).directory(this.outputDirectory).redirectErrorStream(true).command(command).start();
                    final StringBuffer buf = new StringBuffer();
                    StreamPumper outputPumper = new StreamPumper(p.getInputStream(), new StreamConsumer(){

                        public void consumeLine(String line) {
                            CreateEjbStubsMojo.this.getLog().info((CharSequence)line);
                            buf.append(line);
                        }
                    });
                    StreamPumper errorPumper = new StreamPumper(p.getErrorStream(), new StreamConsumer(){

                        public void consumeLine(String line) {
                            CreateEjbStubsMojo.this.getLog().error((CharSequence)line);
                        }
                    });
                    outputPumper.start();
                    errorPumper.start();
                    int exitCode = p.waitFor();
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().info((CharSequence)("Exit Code: '" + exitCode + "'"));
                    }
                    if (exitCode != 0) {
                        throw new MojoExecutionException("Create EJB Stub exit with code: '" + exitCode + "'");
                    }
                    if (buf.toString().endsWith("Command Successful")) return;
                    if (buf.toString().endsWith("ussite de la commande")) return;
                    if (buf.toString().endsWith("Befehl erfolgreich")) return;
                    throw new MojoExecutionException("Error during the creation of EJB Stub failed:\n1. The language use for the build isn't English, French or German\n2. Other error : " + buf.toString());
                }
                catch (IOException e) {
                    this.getLog().info((CharSequence)String.format("cmd failed:%s, retry:%s", StringUtils.join((Object[])command, (String)" "), retry), (Throwable)e);
                    if (++retry != 5) continue;
                    throw new Exception(e);
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to run command: '" + StringUtils.join((Object[])command, (String)" ") + "'", e);
        }
    }

    private static String getExecutable() {
        if (Os.isFamily((String)"windows")) {
            return "bin/createEJBStubs.bat";
        }
        return "bin/createEJBStubs.sh";
    }
}

