/*
 * Decompiled with CFR 0.152.
 */
package org.matomo.sdk.extra;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import java.util.Collections;
import java.util.List;
import org.matomo.sdk.Matomo;
import timber.log.Timber;

public class InstallReferrerReceiver
extends BroadcastReceiver {
    private static final String TAG = Matomo.tag(InstallReferrerReceiver.class);
    static final String REFERRER_SOURCE_GPLAY = "com.android.vending.INSTALL_REFERRER";
    static final String ARG_KEY_GPLAY_REFERRER = "referrer";
    static final String PREF_KEY_INSTALL_REFERRER_EXTRAS = "referrer.extras";
    static final List<String> RESPONSIBILITIES = Collections.singletonList("com.android.vending.INSTALL_REFERRER");

    public void onReceive(Context context, Intent intent) {
        String referrer;
        Timber.tag((String)TAG).d(intent.toString(), new Object[0]);
        if (intent.getAction() == null || !RESPONSIBILITIES.contains(intent.getAction())) {
            Timber.tag((String)TAG).w("Got called outside our responsibilities: %s", new Object[]{intent.getAction()});
            return;
        }
        if (intent.getBooleanExtra("forwarded", false)) {
            Timber.tag((String)TAG).d("Dropping forwarded intent", new Object[0]);
            return;
        }
        if (intent.getAction().equals(REFERRER_SOURCE_GPLAY) && (referrer = intent.getStringExtra(ARG_KEY_GPLAY_REFERRER)) != null) {
            BroadcastReceiver.PendingResult result = this.goAsync();
            new Thread(() -> {
                Matomo.getInstance(context.getApplicationContext()).getPreferences().edit().putString(PREF_KEY_INSTALL_REFERRER_EXTRAS, referrer).apply();
                Timber.tag((String)TAG).d("Stored Google Play referrer extras: %s", new Object[]{referrer});
                result.finish();
            }).start();
        }
        intent.setComponent(null);
        intent.setPackage(context.getPackageName());
        intent.putExtra("forwarded", true);
        context.sendBroadcast(intent);
    }
}

