/*
 * Decompiled with CFR 0.152.
 */
package com.github.mirreck;

import com.github.mirreck.FakeFactory;
import com.github.mirreck.FakeFactoryException;
import com.github.mirreck.RandomUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.ho.yaml.Yaml;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseFakeFactory {
    private static final String ROOT_ELEMENT = "faker";
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseFakeFactory.class);
    private static final String PARAM_PREFIX = "{{";
    private static final String PARAM_SUFFIX = "}}";
    private static final char[] METHOD_NAME_DELIMITERS = new char[]{'_'};
    private static final String DIGITS = "0123456789";
    private static final String LETTERS = "abcdefghijklmnopqrstuvwxyz";
    private Map<String, Object> fakeValuesMap;
    protected final Random random;

    public BaseFakeFactory(Locale locale) {
        this(locale, new Random());
    }

    public BaseFakeFactory(Random random) {
        Map valuesMap = (Map)Yaml.load((InputStream)BaseFakeFactory.class.getResourceAsStream("base.yml"));
        valuesMap = (Map)valuesMap.get("base");
        this.fakeValuesMap = (Map)valuesMap.get(ROOT_ELEMENT);
        this.random = random;
    }

    public BaseFakeFactory(Locale locale, Random random) {
        this(random);
        this.extend(locale);
    }

    protected BaseFakeFactory extend(Locale locale) {
        return this.extend(locale.getLanguage());
    }

    protected BaseFakeFactory extend(String localeExtension) {
        LOGGER.debug("Using locale : {}", (Object)localeExtension);
        Map valuesMap = (Map)Yaml.load((InputStream)BaseFakeFactory.class.getResourceAsStream(localeExtension + ".yml"));
        valuesMap = (Map)valuesMap.get(localeExtension);
        Map extValuesMap = (Map)valuesMap.get(ROOT_ELEMENT);
        this.extendMap(this.fakeValuesMap, extValuesMap);
        return this;
    }

    private void extendMap(Map<String, Object> baseMap, Map<String, Object> extMap) {
        Set<Map.Entry<String, Object>> entrySet = extMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            if (!(entry.getValue() instanceof Map)) {
                if (entry.getValue().equals(baseMap.get(entry.getKey()))) {
                    // empty if block
                }
                baseMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            Map object = (Map)baseMap.get(entry.getKey());
            if (object == null) {
                baseMap.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.extendMap(object, (Map)entry.getValue());
        }
    }

    private Object fetchObject(String key) {
        String[] path = key.split("\\.");
        Object currentValue = this.fakeValuesMap;
        for (String pathSection : path) {
            if (currentValue == null) {
                return null;
            }
            currentValue = currentValue.get(pathSection);
        }
        return currentValue;
    }

    private Object fetch(String key) {
        List valuesArray = (List)this.fetchObject(key);
        if (valuesArray == null) {
            return null;
        }
        return valuesArray.get(org.apache.commons.lang.math.RandomUtils.nextInt((Random)this.random, (int)valuesArray.size()));
    }

    private String fetchString(String key) {
        return (String)this.fetch(key);
    }

    protected Integer fetchInteger(String key) {
        return (Integer)this.fetchObject(key);
    }

    private List<Object> fetchList(String key) {
        Object obj = this.fetchObject(key);
        if (!(obj instanceof List)) {
            throw new FakeFactoryException("Fetched Object is not a List. Key=" + key);
        }
        return (List)obj;
    }

    private static boolean isWeightMap(Object obj) {
        if (!(obj instanceof Map)) {
            return false;
        }
        Map map = (Map)obj;
        if (map.isEmpty()) {
            return false;
        }
        return map.keySet().iterator().next() instanceof String && map.values().iterator().next() instanceof Integer;
    }

    protected String evaluate(String key) {
        Object obj = this.fetchObject(key);
        return this.evaluateObject(obj);
    }

    private String evaluateObject(Object obj) {
        if (obj instanceof List) {
            List list = (List)obj;
            return this.evaluatePattern((String)RandomUtils.randomElement(this.random, list));
        }
        if (BaseFakeFactory.isWeightMap(obj)) {
            Map map = (Map)obj;
            return this.evaluatePattern((String)RandomUtils.randomWeightedElement(this.random, map));
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return this.evaluatePattern(str);
        }
        return null;
    }

    private String evaluatePattern(String pattern) {
        int prefixIndex = pattern.indexOf(PARAM_PREFIX);
        if (prefixIndex != -1) {
            int suffixIndex = pattern.indexOf(PARAM_SUFFIX, prefixIndex);
            if (suffixIndex == -1) {
                throw new FakeFactoryException("Unmatched prefix/suffix");
            }
            String expression = pattern.substring(prefixIndex + PARAM_PREFIX.length(), suffixIndex);
            String replacement = this.evaluate(expression);
            if (replacement == null) {
                replacement = this.evaluateCall(expression);
            }
            return this.evaluatePattern(pattern.substring(0, prefixIndex) + replacement + pattern.substring(suffixIndex + PARAM_SUFFIX.length()));
        }
        return this.bothify(pattern);
    }

    private String evaluateCall(String method) {
        String methodName = this.toCamelCase(method);
        try {
            return (String)FakeFactory.class.getDeclaredMethod(methodName, null).invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            throw new FakeFactoryException("Unable to call method :" + method, e);
        }
    }

    protected String[] evaluateMultipleLines(String key) {
        List<Object> list = this.fetchList(key);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (Object line : list) {
            result.add(this.evaluateObject(line));
        }
        return result.toArray(new String[result.size()]);
    }

    public char digit() {
        return DIGITS.charAt(org.apache.commons.lang.math.RandomUtils.nextInt((Random)this.random, (int)DIGITS.length()));
    }

    public String digits(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(this.digit());
        }
        return sb.toString();
    }

    public char letter() {
        return LETTERS.charAt(org.apache.commons.lang.math.RandomUtils.nextInt((Random)this.random, (int)LETTERS.length()));
    }

    public String letters(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append(this.letter());
        }
        return sb.toString();
    }

    public String numerify(String numberString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numberString.length(); ++i) {
            if (numberString.charAt(i) == '#') {
                sb.append(this.digit());
                continue;
            }
            sb.append(numberString.charAt(i));
        }
        return sb.toString();
    }

    public String letterify(String letterString) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < letterString.length(); ++i) {
            if (letterString.charAt(i) == '?') {
                sb.append(this.letter());
                continue;
            }
            sb.append(letterString.charAt(i));
        }
        return sb.toString();
    }

    public String bothify(String string) {
        return this.letterify(this.numerify(string));
    }

    private String toCamelCase(String methodName) {
        String result = WordUtils.capitalizeFully((String)methodName, (char[])METHOD_NAME_DELIMITERS).replaceAll("_", "");
        result = result.substring(0, 1).toLowerCase() + result.substring(1);
        return result;
    }

    public List<String> words(int num) {
        ArrayList<String> words = new ArrayList<String>();
        for (int i = 0; i < num; ++i) {
            words.add(this.fetchString("lorem.words"));
        }
        return words;
    }

    public List<String> words() {
        return this.words(3);
    }

    public String sentence(int wordCount) {
        return StringUtils.capitalize((String)(StringUtils.join(this.words(wordCount + org.apache.commons.lang.math.RandomUtils.nextInt((Random)this.random, (int)6)), (String)" ") + "."));
    }

    public String sentence() {
        return this.sentence(3);
    }

    public List<String> sentences(int sentenceCount) {
        ArrayList<String> sentences = new ArrayList<String>(sentenceCount);
        for (int i = 0; i < sentenceCount; ++i) {
            sentences.add(this.sentence());
        }
        return sentences;
    }

    public String paragraph(int sentenceCount) {
        return StringUtils.join(this.sentences(sentenceCount + org.apache.commons.lang.math.RandomUtils.nextInt((Random)this.random, (int)3)), (String)" ");
    }

    public String paragraph() {
        return this.paragraph(3);
    }

    public List<String> paragraphs(int paragraphCount) {
        ArrayList<String> paragraphs = new ArrayList<String>(paragraphCount);
        for (int i = 0; i < paragraphCount; ++i) {
            paragraphs.add(this.paragraph());
        }
        return paragraphs;
    }

    public Date date(int minYear, int maxYear) {
        DateTime dt = new DateTime().withYear(RandomUtils.intInInterval(this.random, minYear, maxYear)).withDayOfYear(RandomUtils.intInInterval(this.random, 0, 365));
        return dt.toDate();
    }

    public double[] coordinatesLatLng() {
        return new double[]{RandomUtils.doubleInInterval(this.random, -90.0, 90.0), RandomUtils.doubleInInterval(this.random, -180.0, 180.0)};
    }
}

