/*
 * Decompiled with CFR 0.152.
 */
package com.github.mirreck;

import com.github.mirreck.BaseFakeFactory;
import com.github.mirreck.RandomUtils;
import com.github.mirreck.domain.Gender;
import java.util.Locale;
import java.util.Random;
import org.apache.commons.lang.WordUtils;

public class FakeFactory
extends BaseFakeFactory {
    private static final String ADDRESS_SECONDARY_ADDRESS = "address.secondary_address";
    private static final String ADDRESS_STREET_ADDRESS = "address.street_address";

    public FakeFactory() {
        super(Locale.ENGLISH);
    }

    public FakeFactory(Random random) {
        super(Locale.ENGLISH, random);
    }

    public FakeFactory(Locale locale) {
        super(locale);
    }

    public FakeFactory(Locale locale, Random random) {
        super(locale, random);
    }

    public String name() {
        return this.evaluate("name.formats");
    }

    public String firstName() {
        return this.evaluate("name.first_name");
    }

    public String firstName(Gender gender) {
        if (Gender.F.equals((Object)gender)) {
            return this.evaluate("name.female_first_name");
        }
        return this.evaluate("name.male_first_name");
    }

    public String lastName() {
        return this.evaluate("name.last_name");
    }

    public String nameTitle() {
        return this.evaluate("name.title");
    }

    public String phoneNumber() {
        return this.evaluate("phone_number.formats");
    }

    public String cellPhoneNumber() {
        return this.evaluate("cell_phone_number.formats");
    }

    public String email() {
        return this.evaluate("internet.email").toLowerCase();
    }

    public String streetName() {
        return this.evaluate("address.street_name.formats");
    }

    public String streetAddress() {
        return this.evaluate(ADDRESS_STREET_ADDRESS);
    }

    public String secondaryAddress() {
        return this.evaluate(ADDRESS_SECONDARY_ADDRESS);
    }

    public String[] streetAddressWithSecondary() {
        return new String[]{this.evaluate(ADDRESS_STREET_ADDRESS), this.evaluate(ADDRESS_SECONDARY_ADDRESS)};
    }

    public String zipCode() {
        return this.evaluate("address.postcode");
    }

    public String city() {
        return WordUtils.capitalizeFully((String)this.evaluate("city.formats"));
    }

    public String country() {
        return this.evaluate("address.country");
    }

    public int height() {
        return RandomUtils.gaussianInt(this.random, this.fetchInteger("measurements.height.min"), this.fetchInteger("measurements.height.max"));
    }

    public String eyeColor() {
        return this.evaluate("measurements.eye_color");
    }

    public String[] fullAddress() {
        return new String[]{this.evaluate("address.line1"), this.evaluate("address.line2")};
    }
}

