/*
 * Decompiled with CFR 0.152.
 */
package com.github.mirreck;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class RandomUtils {
    private static final double GAUSSIAN_LIMIT = 3.0;

    private RandomUtils() {
    }

    private static Random newRandom() {
        return new Random(System.currentTimeMillis());
    }

    public static <T> T randomElement(T[] array) {
        return RandomUtils.randomElement(RandomUtils.newRandom(), array);
    }

    public static <T> T randomElement(Random random, T[] array) {
        return array[org.apache.commons.lang.math.RandomUtils.nextInt((Random)random, (int)array.length)];
    }

    public static <T> T randomElement(Set<T> set) {
        return RandomUtils.randomElement(RandomUtils.newRandom(), set);
    }

    public static <T> T randomElement(Random random, Set<T> set) {
        return (T)set.toArray()[org.apache.commons.lang.math.RandomUtils.nextInt((Random)random, (int)set.size())];
    }

    public static <T> T randomElement(List<T> list) {
        return RandomUtils.randomElement(RandomUtils.newRandom(), list);
    }

    public static <T> T randomElement(Random random, List<T> list) {
        return list.get(org.apache.commons.lang.math.RandomUtils.nextInt((Random)random, (int)list.size()));
    }

    public static <T> T randomWeightedElement(Map<T, Integer> map) {
        return RandomUtils.randomWeightedElement(RandomUtils.newRandom(), map);
    }

    public static <T> T randomWeightedElement(Random random, Map<T, Integer> map) {
        Collection<Integer> values = map.values();
        int totalWeight = 0;
        for (Integer val : values) {
            totalWeight += val.intValue();
        }
        int index = org.apache.commons.lang.math.RandomUtils.nextInt((Random)random, (int)totalWeight);
        int i = 0;
        for (Map.Entry<T, Integer> entry : map.entrySet()) {
            int next = i + entry.getValue();
            if (index >= i && index < next) {
                return entry.getKey();
            }
            i = next;
        }
        return null;
    }

    public static int intInInterval(int min, int max) {
        return RandomUtils.intInInterval(RandomUtils.newRandom(), min, max);
    }

    public static int intInInterval(Random random, int min, int max) {
        return min + random.nextInt(max - min);
    }

    public static double doubleInInterval(double min, double max) {
        return RandomUtils.doubleInInterval(RandomUtils.newRandom(), min, max);
    }

    public static double doubleInInterval(Random random, double min, double max) {
        return min + (max - min) * random.nextDouble();
    }

    public static int gaussianInt(Random random, int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException("max < min");
        }
        double det = (random.nextGaussian() + 3.0) / 3.0 / 2.0;
        return min + (int)(det * (double)(max - min));
    }
}

