/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool;

import com.thebuzzmedia.exiftool.ExecutionStrategy;
import com.thebuzzmedia.exiftool.Format;
import com.thebuzzmedia.exiftool.Tag;
import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.VersionCache;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.core.StandardFormat;
import com.thebuzzmedia.exiftool.core.cache.VersionCacheFactory;
import com.thebuzzmedia.exiftool.core.handlers.StopHandler;
import com.thebuzzmedia.exiftool.core.handlers.TagHandler;
import com.thebuzzmedia.exiftool.exceptions.UnsupportedFeatureException;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ExifTool
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ExifTool.class);
    private static final VersionCache cache = VersionCacheFactory.newCache();
    private final CommandExecutor executor;
    private final String path;
    private final Version version;
    private final ExecutionStrategy strategy;

    ExifTool(String path, CommandExecutor executor, ExecutionStrategy strategy) {
        this.executor = PreConditions.notNull(executor, "Executor should not be null", new Object[0]);
        this.path = PreConditions.notBlank(path, "ExifTool path should not be null", new Object[0]);
        this.strategy = PreConditions.notNull(strategy, "Execution strategy should not be null", new Object[0]);
        this.version = cache.load(path, executor);
        if (this.version != null && !strategy.isSupported(this.version)) {
            throw new UnsupportedFeatureException(path, this.version);
        }
    }

    @Override
    public void close() throws Exception {
        this.strategy.close();
    }

    public boolean isRunning() {
        return this.strategy.isRunning();
    }

    public Version getVersion() {
        return this.version;
    }

    public Map<Tag, String> getImageMeta(File image, Collection<Tag> tags) throws IOException {
        return this.getImageMeta(image, StandardFormat.NUMERIC, tags);
    }

    public Map<Tag, String> getImageMeta(File image, Format format, Collection<Tag> tags) throws IOException {
        PreConditions.notNull(image, "Image cannot be null and must be a valid stream of image data.", new Object[0]);
        PreConditions.notNull(format, "Format cannot be null.", new Object[0]);
        PreConditions.notEmpty(tags, "Tags cannot be null and must contain 1 or more Tag to query the image for.", new Object[0]);
        PreConditions.isReadable(image, "Unable to read the given image [%s], ensure that the image exists at the given withPath and that the executing Java process has permissions to read it.", image);
        log.debug("Querying %s tags from image: %s", tags.size(), image);
        TagHandler tagHandler = new TagHandler(tags);
        List<String> args = this.getImageMetaArguments(format, image, tags);
        this.strategy.execute(this.executor, this.path, args, tagHandler);
        log.debug("Image Meta Processed [queried %s, found %s values]", tagHandler.size(), tagHandler.size());
        return tagHandler.getTags();
    }

    public void setImageMeta(File image, Map<Tag, String> tags) throws IOException {
        this.setImageMeta(image, StandardFormat.NUMERIC, tags);
    }

    public void setImageMeta(File image, Format format, Map<Tag, String> tags) throws IOException {
        PreConditions.notNull(image, "Image cannot be null and must be a valid stream of image data.", new Object[0]);
        PreConditions.notNull(format, "Format cannot be null.", new Object[0]);
        PreConditions.notEmpty(tags, "Tags cannot be null and must contain 1 or more Tag to query the image for.", new Object[0]);
        PreConditions.isWritable(image, "Unable to read the given image [%s], ensure that the image exists at the given withPath and that the executing Java process has permissions to read it.", image);
        log.debug("Writing %d tags to image: %s", tags.size(), image);
        long startTime = System.currentTimeMillis();
        List<String> args = this.setImageMetaArguments(format, image, tags);
        this.strategy.execute(this.executor, this.path, args, StopHandler.stopHandler());
        log.debug("Image Meta Processed in %d ms [write %d tags]", System.currentTimeMillis() - startTime, tags.size());
    }

    private List<String> getImageMetaArguments(Format format, File image, Collection<Tag> tags) {
        LinkedList<String> args = new LinkedList<String>();
        args.addAll(format.getArgs());
        args.add("-S");
        for (Tag tag : tags) {
            args.add("-" + tag.getName());
        }
        args.add(image.getAbsolutePath());
        args.add("-execute");
        return args;
    }

    private List<String> setImageMetaArguments(Format format, File image, Map<Tag, String> tags) {
        LinkedList<String> args = new LinkedList<String>();
        args.addAll(format.getArgs());
        args.add("-S");
        for (Map.Entry<Tag, String> entry : tags.entrySet()) {
            args.add("-" + entry.getKey().getName() + "=" + entry.getValue());
        }
        args.add(image.getAbsolutePath());
        args.add("-execute");
        return args;
    }
}

