/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.io;

import com.thebuzzmedia.exiftool.commons.io.StreamVisitor;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public final class IOs {
    private static final Logger log = LoggerFactory.getLogger(IOs.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    private IOs() {
    }

    public static void readInputStream(InputStream is, StreamVisitor visitor) throws IOException {
        log.trace("Read input stream", new Object[0]);
        String line = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(is, UTF_8));
        try {
            boolean hasNext = true;
            while (hasNext) {
                line = br.readLine();
                hasNext = visitor.readLine(line);
                log.trace("  - Line: %s", line);
                log.trace("  - Continue: %s", hasNext);
            }
        }
        catch (IOException ex) {
            log.error((CharSequence)ex.getMessage(), ex);
            throw ex;
        }
        finally {
            if (line == null) {
                IOs.closeQuietly(br);
            }
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
        }
    }
}

