/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.commons.iterables;

import com.thebuzzmedia.exiftool.commons.iterables.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Collections {
    private Collections() {
    }

    public static <T> boolean isEmpty(Collection<T> values) {
        return values == null || values.isEmpty();
    }

    public static <T> int size(Collection<T> values) {
        return Collections.isEmpty(values) ? 0 : values.size();
    }

    public static <T> String join(Collection<T> values, String separator) {
        if (Collections.isEmpty(values)) {
            return "";
        }
        Iterator<T> it = values.iterator();
        StringBuilder sb = new StringBuilder();
        sb.append(it.next());
        while (it.hasNext()) {
            sb.append(separator).append(it.next());
        }
        return sb.toString();
    }

    public static <T, U> List<U> map(List<T> inputs, Mapper<T, U> mapper) {
        ArrayList<U> outputs = new ArrayList<U>(inputs.size());
        for (T input : inputs) {
            U output = mapper.map(input);
            outputs.add(output);
        }
        return outputs;
    }

    public static <T, U> Map<U, T> indexBy(Iterable<T> inputs, Mapper<T, U> indexer) {
        HashMap<U, T> index = new HashMap<U, T>();
        for (T input : inputs) {
            U output = indexer.map(input);
            index.put(output, input);
        }
        return index;
    }
}

