/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core;

import com.thebuzzmedia.exiftool.Tag;

public enum StandardTag implements Tag
{
    ISO("ISO", Type.INTEGER),
    APERTURE("ApertureValue", Type.DOUBLE),
    WHITE_BALANCE("WhiteBalance", Type.INTEGER),
    CONTRAST("Contrast", Type.INTEGER),
    SATURATION("Saturation", Type.INTEGER),
    SHARPNESS("Sharpness", Type.INTEGER),
    SHUTTER_SPEED("ShutterSpeedValue", Type.DOUBLE),
    DIGITAL_ZOOM_RATIO("DigitalZoomRatio", Type.DOUBLE),
    IMAGE_WIDTH("ImageWidth", Type.INTEGER),
    IMAGE_HEIGHT("ImageHeight", Type.INTEGER),
    X_RESOLUTION("XResolution", Type.DOUBLE),
    Y_RESOLUTION("YResolution", Type.DOUBLE),
    FLASH("Flash", Type.INTEGER),
    METERING_MODE("MeteringMode", Type.INTEGER),
    FOCAL_LENGTH("FocalLength", Type.DOUBLE),
    FOCAL_LENGTH_35MM("FocalLengthIn35mmFormat", Type.INTEGER),
    EXPOSURE_TIME("ExposureTime", Type.DOUBLE),
    EXPOSURE_COMPENSATION("ExposureCompensation", Type.DOUBLE),
    EXPOSURE_PROGRAM("ExposureProgram", Type.INTEGER),
    ORIENTATION("Orientation", Type.INTEGER),
    COLOR_SPACE("ColorSpace", Type.INTEGER),
    SENSING_METHOD("SensingMethod", Type.INTEGER),
    SOFTWARE("Software", Type.STRING),
    MAKE("Make", Type.STRING),
    MODEL("Model", Type.STRING),
    LENS_MAKE("LensMake", Type.STRING),
    LENS_MODEL("LensModel", Type.STRING),
    OWNER_NAME("OwnerName", Type.STRING),
    TITLE("XPTitle", Type.STRING),
    AUTHOR("XPAuthor", Type.STRING),
    SUBJECT("XPSubject", Type.STRING),
    KEYWORDS("XPKeywords", Type.STRING),
    COMMENT("XPComment", Type.STRING),
    RATING("Rating", Type.INTEGER),
    RATING_PERCENT("RatingPercent", Type.INTEGER),
    DATE_TIME_ORIGINAL("DateTimeOriginal", Type.STRING),
    CREATION_DATE("CreationDate", Type.STRING),
    GPS_LATITUDE("GPSLatitude", Type.DOUBLE),
    GPS_LATITUDE_REF("GPSLatitudeRef", Type.STRING),
    GPS_LONGITUDE("GPSLongitude", Type.DOUBLE),
    GPS_LONGITUDE_REF("GPSLongitudeRef", Type.STRING),
    GPS_ALTITUDE("GPSAltitude", Type.DOUBLE),
    GPS_ALTITUDE_REF("GPSAltitudeRef", Type.INTEGER),
    GPS_SPEED("GPSSpeed", Type.DOUBLE),
    GPS_SPEED_REF("GPSSpeedRef", Type.STRING),
    GPS_PROCESS_METHOD("GPSProcessingMethod", Type.STRING),
    GPS_BEARING("GPSDestBearing", Type.DOUBLE),
    GPS_BEARING_REF("GPSDestBearingRef", Type.STRING),
    GPS_TIMESTAMP("GPSTimeStamp", Type.STRING),
    ROTATION("Rotation", Type.INTEGER),
    EXIF_VERSION("ExifVersion", Type.STRING),
    LENS_ID("LensID", Type.STRING),
    COPYRIGHT("Copyright", Type.STRING),
    ARTIST("Artist", Type.STRING),
    SUB_SEC_TIME_ORIGINAL("SubSecTimeOriginal", Type.INTEGER),
    OBJECT_NAME("ObjectName", Type.STRING),
    CAPTION_ABSTRACT("Caption-Abstract", Type.STRING),
    CREATOR("Creator", Type.STRING),
    IPTC_KEYWORDS("Keywords", Type.STRING),
    COPYRIGHT_NOTICE("CopyrightNotice", Type.STRING),
    FILE_TYPE("FileType", Type.STRING),
    AVG_BITRATE("AvgBitrate", Type.STRING),
    MIME_TYPE("MIMEType", Type.STRING);

    private final String name;
    private final Type type;

    private StandardTag(String name, Type type) {
        this.name = name;
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <T> T parse(String value) {
        return this.type.parse(value);
    }

    private static enum Type {
        INTEGER{

            @Override
            public <T> T parse(String value) {
                return (T)Integer.valueOf(Integer.parseInt(value));
            }
        }
        ,
        DOUBLE{

            @Override
            public <T> T parse(String value) {
                return (T)Double.valueOf(Double.parseDouble(value));
            }
        }
        ,
        STRING{

            @Override
            public <T> T parse(String value) {
                return (T)value;
            }
        };


        public abstract <T> T parse(String var1);
    }
}

