/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.cache;

import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.CommandResult;
import com.thebuzzmedia.exiftool.process.command.CommandBuilder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Callable;

class VersionCallable
implements Callable<Version> {
    private static final Logger log = LoggerFactory.getLogger(VersionCallable.class);
    private final String exifTool;
    private final WeakReference<CommandExecutor> executor;

    VersionCallable(String exifTool, CommandExecutor executor) {
        this.exifTool = exifTool;
        this.executor = new WeakReference<CommandExecutor>(executor);
    }

    @Override
    public Version call() throws Exception {
        log.debug("Checking exiftool (path: %s) version", this.exifTool);
        try {
            CommandExecutor commandExecutor = (CommandExecutor)this.executor.get();
            if (commandExecutor == null) {
                log.warn("Command executor has already been garbage collected, cannot parse version", new Object[0]);
                return null;
            }
            CommandResult result = commandExecutor.execute(CommandBuilder.builder(this.exifTool).addArgument("-ver", new String[0]).build());
            return result.isSuccess() ? new Version(result.getOutput()) : null;
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
            return null;
        }
    }
}

