/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.handlers;

import com.thebuzzmedia.exiftool.Tag;
import com.thebuzzmedia.exiftool.commons.iterables.Mapper;
import com.thebuzzmedia.exiftool.core.handlers.StopHandler;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.OutputHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class TagHandler
implements OutputHandler {
    private static final Logger log = LoggerFactory.getLogger(TagHandler.class);
    private static final Pattern TAG_VALUE_PATTERN = Pattern.compile(": ");
    private static final Indexer INDEXER = new Indexer();
    private final Map<Tag, String> tags = new HashMap<Tag, String>();
    private final Map<String, Tag> inputs;

    public TagHandler(Collection<Tag> tags) {
        this.inputs = Collections.unmodifiableMap(com.thebuzzmedia.exiftool.commons.iterables.Collections.indexBy(tags, INDEXER));
    }

    @Override
    public boolean readLine(String line) {
        if (!StopHandler.stopHandler().readLine(line)) {
            return false;
        }
        String[] pair = TAG_VALUE_PATTERN.split(line, 2);
        if (pair != null && pair.length == 2) {
            String name = pair[0];
            String value = pair[1];
            Tag tag = this.inputs.get(name);
            if (tag != null) {
                this.tags.put(tag, value);
                log.debug("Read Tag [name=%s, value=%s]", tag, pair[1]);
            } else {
                log.debug("Unable to read Tag: %s", line);
            }
        } else {
            log.warn("Skipped line: %s", line);
        }
        return true;
    }

    public Map<Tag, String> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public int size() {
        return this.tags.size();
    }

    private static class Indexer
    implements Mapper<Tag, String> {
        private Indexer() {
        }

        @Override
        public String map(Tag input) {
            return input.getName();
        }
    }
}

