/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.schedulers;

import com.thebuzzmedia.exiftool.Scheduler;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DefaultScheduler
implements Scheduler {
    private final long delay;
    private final TimeUnit timeUnit;
    private final ScheduledThreadPoolExecutor executor;

    public DefaultScheduler(long delay) {
        this(delay, TimeUnit.MILLISECONDS);
    }

    public DefaultScheduler(long delay, TimeUnit timeUnit) {
        this.delay = PreConditions.isPositive(delay, "Delay should be a strictly positive value", new Object[0]);
        this.timeUnit = PreConditions.notNull(timeUnit, "Time Unit should not be null", new Object[0]);
        this.executor = new ScheduledThreadPoolExecutor(1);
        this.executor.setRemoveOnCancelPolicy(true);
    }

    @Override
    public synchronized void start(Runnable runnable) {
        this.executor.schedule(runnable, this.delay, this.timeUnit);
    }

    @Override
    public synchronized void stop() {
        for (Runnable runnable : this.executor.getQueue()) {
            ((RunnableFuture)runnable).cancel(false);
        }
        this.executor.purge();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.stop();
        this.executor.shutdownNow();
    }
}

