/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.core.strategies;

import com.thebuzzmedia.exiftool.ExecutionStrategy;
import com.thebuzzmedia.exiftool.Scheduler;
import com.thebuzzmedia.exiftool.Version;
import com.thebuzzmedia.exiftool.commons.iterables.Collections;
import com.thebuzzmedia.exiftool.commons.iterables.Mapper;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.CommandProcess;
import com.thebuzzmedia.exiftool.process.OutputHandler;
import com.thebuzzmedia.exiftool.process.command.CommandBuilder;
import java.io.IOException;
import java.util.List;

public class StayOpenStrategy
implements ExecutionStrategy {
    private static final Logger log = LoggerFactory.getLogger(StayOpenStrategy.class);
    private static final ArgumentMapper MAPPER = new ArgumentMapper();
    private static final Version V8_36 = new Version("8.36");
    private final Scheduler scheduler;
    private CommandProcess process;

    public StayOpenStrategy(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(CommandExecutor executor, String exifTool, List<String> arguments, OutputHandler handler) throws IOException {
        log.debug("Using ExifTool in daemon mode (-stay_open True)...", new Object[0]);
        List<String> newArgs = Collections.map(arguments, MAPPER);
        StayOpenStrategy stayOpenStrategy = this;
        synchronized (stayOpenStrategy) {
            if (this.process == null || this.process.isClosed()) {
                log.debug("Start exiftool process", new Object[0]);
                this.process = executor.start(CommandBuilder.builder(exifTool).addArgument("-stay_open", "True", "-@", "-").build());
            }
            this.scheduler.stop();
            this.scheduler.start(new Runnable(){

                @Override
                public void run() {
                    StayOpenStrategy.this.safeClose();
                }
            });
            try {
                this.process.write(newArgs);
                this.process.flush();
                this.process.read(handler);
            }
            catch (IOException ex) {
                log.error((CharSequence)ex.getMessage(), ex);
                throw ex;
            }
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return this.process != null && this.process.isRunning();
    }

    @Override
    public boolean isSupported(Version version) {
        return V8_36.compareTo(version) <= 0;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.process != null) {
            this.closeScheduler();
            this.closeProcess();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    private synchronized void closeScheduler() {
        try {
            log.debug("Attempting to stop cleanup task", new Object[0]);
            this.scheduler.stop();
            log.debug("Cleanup task successfully stopped", new Object[0]);
        }
        catch (Exception ex) {
            log.warn("Cleanup task failed to stop", new Object[0]);
            log.warn(ex.getMessage(), ex);
        }
    }

    private synchronized void closeProcess() throws Exception {
        try {
            log.debug("Attempting to close ExifTool daemon process, issuing '-stay_open\\nFalse\\n' command...", new Object[0]);
            this.process.write("-stay_open\nFalse\n", new String[0]);
            this.process.flush();
            this.process.close();
            log.debug("ExifTool daemon process successfully closed", new Object[0]);
        }
        catch (Exception ex) {
            log.warn("ExifTool daemon failed to stop", new Object[0]);
            log.warn(ex.getMessage(), ex);
            throw ex;
        }
        finally {
            this.process = null;
        }
    }

    private synchronized void safeClose() {
        try {
            this.close();
        }
        catch (Exception ex) {
            log.error((CharSequence)ex.getMessage(), ex);
        }
    }

    private static class ArgumentMapper
    implements Mapper<String, String> {
        private static final String BR = System.getProperty("line.separator");

        private ArgumentMapper() {
        }

        @Override
        public String map(String input) {
            return input + BR;
        }
    }
}

