/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.logs;

import com.thebuzzmedia.exiftool.logs.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;

class DefaultLogger
implements Logger {
    private final Level level;

    DefaultLogger(boolean debug) {
        this.level = debug ? Level.TRACE : Level.INFO;
    }

    @Override
    public void trace(CharSequence message, Object ... params) {
        this.print(Level.TRACE, message, params);
    }

    @Override
    public void info(CharSequence message, Object ... params) {
        this.print(Level.INFO, message, params);
    }

    @Override
    public void debug(CharSequence message, Object ... params) {
        this.print(Level.DEBUG, message, params);
    }

    @Override
    public void warn(CharSequence message, Object ... params) {
        this.print(Level.WARN, message, params);
    }

    @Override
    public void error(CharSequence message, Object ... params) {
        this.print(Level.ERROR, message, params);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG);
    }

    @Override
    public void error(CharSequence message, Throwable ex) {
        StringWriter errors = new StringWriter();
        ex.printStackTrace(new PrintWriter(errors));
        this.print(Level.ERROR, message, new Object[0]);
        this.print(Level.ERROR, errors.toString(), new Object[0]);
    }

    private boolean isEnabled(Level level) {
        return this.level.compareTo(level) <= 0;
    }

    private void print(Level level, CharSequence message, Object ... params) {
        if (this.isEnabled(level)) {
            String str;
            String string = str = message == null ? null : message.toString();
            if (str != null && params.length > 0) {
                str = String.format(str, params);
            }
            System.out.println("[" + (Object)((Object)level) + "] [exiftool] " + str);
        }
    }

    private static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

