/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.logs;

import com.thebuzzmedia.exiftool.commons.reflection.ClassUtils;
import com.thebuzzmedia.exiftool.logs.DefaultLogger;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerLog4j;
import com.thebuzzmedia.exiftool.logs.LoggerSlf4j;

public final class LoggerFactory {
    private LoggerFactory() {
    }

    public static Logger getLogger(Class<?> klass) {
        if (ClassUtils.isPresent("org.slf4j.Logger")) {
            org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(klass);
            return new LoggerSlf4j(log);
        }
        if (ClassUtils.isPresent("org.apache.log4j.Logger")) {
            org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(klass);
            return new LoggerLog4j(log);
        }
        return new DefaultLogger(Boolean.getBoolean("exiftool.debug"));
    }
}

