/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.process.command;

import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.process.Command;
import com.thebuzzmedia.exiftool.process.command.DefaultCommand;
import java.util.LinkedList;
import java.util.List;

public class CommandBuilder {
    private final String executable;
    private final List<String> arguments;

    public static CommandBuilder builder(String executable) {
        return new CommandBuilder(executable);
    }

    private CommandBuilder(String executable) {
        this.executable = PreConditions.notBlank(executable, "Command line executable should be defined", new Object[0]);
        this.arguments = new LinkedList<String>();
    }

    public CommandBuilder addArgument(String arg, String ... args) {
        this.add(arg);
        if (args.length > 0) {
            for (String a : args) {
                this.add(a);
            }
        }
        return this;
    }

    public CommandBuilder addAll(Iterable<String> arguments) {
        PreConditions.notEmpty(arguments, "Arguments should not be empty", new Object[0]);
        for (String arg : arguments) {
            this.add(arg);
        }
        return this;
    }

    public Command build() {
        return new DefaultCommand(this.executable, this.arguments);
    }

    private void add(String arg) {
        this.arguments.add(PreConditions.notBlank(arg, "Command line argument should be defined if set", new Object[0]));
    }
}

