/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.process.executor;

import com.thebuzzmedia.exiftool.commons.io.IOs;
import com.thebuzzmedia.exiftool.commons.lang.PreConditions;
import com.thebuzzmedia.exiftool.logs.Logger;
import com.thebuzzmedia.exiftool.logs.LoggerFactory;
import com.thebuzzmedia.exiftool.process.Command;
import com.thebuzzmedia.exiftool.process.CommandExecutor;
import com.thebuzzmedia.exiftool.process.CommandProcess;
import com.thebuzzmedia.exiftool.process.CommandResult;
import com.thebuzzmedia.exiftool.process.OutputHandler;
import com.thebuzzmedia.exiftool.process.executor.CompositeHandler;
import com.thebuzzmedia.exiftool.process.executor.DefaultCommandProcess;
import com.thebuzzmedia.exiftool.process.executor.DefaultCommandResult;
import com.thebuzzmedia.exiftool.process.executor.ResultHandler;
import java.io.IOException;
import java.util.List;

public class DefaultCommandExecutor
implements CommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultCommandExecutor.class);

    @Override
    public CommandResult execute(Command command) throws IOException {
        return this.readProcessOutput(command, null);
    }

    @Override
    public CommandResult execute(Command command, OutputHandler handler) throws IOException {
        return this.readProcessOutput(command, PreConditions.notNull(handler, "Handler should not be null", new Object[0]));
    }

    @Override
    public CommandProcess start(Command command) throws IOException {
        Process proc = this.createProcess(command);
        return new DefaultCommandProcess(proc.getInputStream(), proc.getOutputStream(), proc.getErrorStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResult readProcessOutput(Command cmd, OutputHandler h) throws IOException {
        Process proc = this.createProcess(cmd);
        ResultHandler h1 = new ResultHandler();
        OutputHandler handler = h == null ? h1 : new CompositeHandler(h, h1);
        IOs.readInputStream(proc.getInputStream(), handler);
        try {
            proc.waitFor();
            DefaultCommandResult defaultCommandResult = new DefaultCommandResult(proc.exitValue(), h1.getOutput());
            return defaultCommandResult;
        }
        catch (InterruptedException ex) {
            log.error((CharSequence)ex.getMessage(), ex);
            DefaultCommandResult defaultCommandResult = new DefaultCommandResult(-1, null);
            return defaultCommandResult;
        }
        finally {
            IOs.closeQuietly(proc.getInputStream());
            IOs.closeQuietly(proc.getOutputStream());
            IOs.closeQuietly(proc.getErrorStream());
        }
    }

    private Process createProcess(Command command) throws IOException {
        try {
            List<String> args = command.getArguments();
            return new ProcessBuilder(args).start();
        }
        catch (IOException ex) {
            log.error((CharSequence)ex.getMessage(), ex);
            throw ex;
        }
    }
}

