/*
 * Decompiled with CFR 0.152.
 */
package com.thebuzzmedia.exiftool.logs;

import com.thebuzzmedia.exiftool.logs.LogUtils;
import com.thebuzzmedia.exiftool.logs.Logger;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

class LoggerLog4j
implements Logger {
    private final org.apache.log4j.Logger log;

    LoggerLog4j(Class<?> name) {
        this.log = org.apache.log4j.Logger.getLogger(name);
    }

    @Override
    public void trace(String message) {
        this.print(Level.TRACE, message);
    }

    @Override
    public void trace(String message, Object p1) {
        this.print(Level.TRACE, message, p1);
    }

    @Override
    public void trace(String message, Object p1, Object p2) {
        this.print(Level.TRACE, message, p1, p2);
    }

    @Override
    public void info(String message) {
        this.print(Level.INFO, message);
    }

    @Override
    public void info(String message, Object p1) {
        this.print(Level.INFO, message, p1);
    }

    @Override
    public void info(String message, Object p1, Object p2) {
        this.print(Level.INFO, message, p1, p2);
    }

    @Override
    public void debug(String message) {
        this.print(Level.DEBUG, message);
    }

    @Override
    public void debug(String message, Object p1) {
        this.print(Level.DEBUG, message, p1);
    }

    @Override
    public void debug(String message, Object p1, Object p2) {
        this.print(Level.DEBUG, message, p1, p2);
    }

    @Override
    public void warn(String message) {
        this.print(Level.WARN, message);
    }

    @Override
    public void warn(String message, Throwable ex) {
        this.printThrowable(Level.WARN, message, ex);
    }

    @Override
    public void warn(String message, Object p1) {
        this.print(Level.WARN, message, p1);
    }

    @Override
    public void warn(String message, Object p1, Object p2) {
        this.print(Level.WARN, message, p1, p2);
    }

    @Override
    public void error(String message) {
        this.print(Level.ERROR, message);
    }

    @Override
    public void error(String message, Object p1) {
        this.print(Level.ERROR, message, p1);
    }

    @Override
    public void error(String message, Object p1, Object p2) {
        this.print(Level.ERROR, message, p1, p2);
    }

    @Override
    public void error(String message, Throwable ex) {
        this.printThrowable(Level.ERROR, message, ex);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isDebugEnabled();
    }

    private void print(Level level, String message) {
        if (this.log.isEnabledFor((Priority)level)) {
            this.log.log((Priority)level, (Object)message);
        }
    }

    private void print(Level level, String message, Object p1) {
        if (this.log.isEnabledFor((Priority)level)) {
            this.log.log((Priority)level, (Object)String.format(LogUtils.fromSlf4jStyle(message), p1));
        }
    }

    private void print(Level level, String message, Object p1, Object p2) {
        if (this.log.isEnabledFor((Priority)level)) {
            this.log.log((Priority)level, (Object)String.format(LogUtils.fromSlf4jStyle(message), p1, p2));
        }
    }

    private void printThrowable(Level level, String message, Throwable ex) {
        if (this.log.isEnabledFor((Priority)level)) {
            this.log.log((Priority)level, (Object)message, ex);
        }
    }
}

