/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.apache;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpRequest;
import com.github.mjeanroy.junit.servers.client.impl.apache.ApacheHttpResponseFactory;
import com.github.mjeanroy.junit.servers.commons.CollectionUtils;
import com.github.mjeanroy.junit.servers.commons.Mapper;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;

class ApacheHttpRequest
extends AbstractHttpRequest
implements HttpRequest {
    private static final ApacheHttpRequestFactory FACTORY = new ApacheHttpRequestFactory();
    private final HttpClient client;
    private static final Mapper<HttpParameter, NameValuePair> PARAM_MAPPER = new Mapper<HttpParameter, NameValuePair>(){

        @Override
        public NameValuePair apply(HttpParameter parameter) {
            return new BasicNameValuePair(parameter.getName(), parameter.getValue());
        }
    };

    ApacheHttpRequest(HttpClient client, HttpMethod httpMethod, HttpUrl endpoint) {
        super(endpoint, httpMethod);
        this.client = client;
    }

    @Override
    protected HttpResponse doExecute() throws Exception {
        HttpMethod method = this.getMethod();
        HttpRequestBase httpRequest = FACTORY.create(method);
        httpRequest.setURI(this.createRequestURI());
        this.handleHeaders(httpRequest);
        this.handleCookies(httpRequest);
        this.handleBody(httpRequest);
        long start = System.nanoTime();
        org.apache.http.HttpResponse httpResponse = this.client.execute((HttpUriRequest)httpRequest);
        long duration = System.nanoTime() - start;
        return ApacheHttpResponseFactory.of(httpResponse, duration);
    }

    private void handleBody(HttpRequestBase httpRequest) {
        if (this.hasBody()) {
            HttpEntityEnclosingRequestBase rq = (HttpEntityEnclosingRequestBase)httpRequest;
            if (!this.formParams.isEmpty()) {
                this.handleFormParameters(rq);
            } else if (this.body != null) {
                this.handleRequestBody(rq);
            }
        }
    }

    private URI createRequestURI() throws URISyntaxException {
        URI uri = this.getEndpoint().toURI();
        URIBuilder builder = new URIBuilder(uri).setCharset(StandardCharsets.UTF_8);
        for (HttpParameter parameter : this.queryParams.values()) {
            builder.addParameter(parameter.getName(), parameter.getValue());
        }
        return builder.build();
    }

    private void handleHeaders(HttpRequestBase httpRequest) {
        for (HttpHeader header : this.headers.values()) {
            httpRequest.addHeader(header.getName(), header.serializeValues());
        }
    }

    private void handleFormParameters(HttpEntityEnclosingRequestBase httpRequest) {
        List<NameValuePair> pairs = CollectionUtils.map(this.formParams.values(), PARAM_MAPPER);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, Charset.defaultCharset());
        httpRequest.setEntity((HttpEntity)entity);
    }

    private void handleRequestBody(HttpEntityEnclosingRequestBase httpRequest) {
        StringEntity entity = new StringEntity(this.body, Charset.defaultCharset());
        httpRequest.setEntity((HttpEntity)entity);
    }

    private void handleCookies(HttpRequestBase httpRequest) {
        if (!this.cookies.isEmpty()) {
            httpRequest.addHeader("Cookie", Cookies.serialize(this.cookies));
        }
    }

    private static class ApacheHttpRequestFactory {
        private ApacheHttpRequestFactory() {
        }

        HttpRequestBase create(HttpMethod httpMethod) {
            if (httpMethod == HttpMethod.GET) {
                return new HttpGet();
            }
            if (httpMethod == HttpMethod.POST) {
                return new HttpPost();
            }
            if (httpMethod == HttpMethod.PUT) {
                return new HttpPut();
            }
            if (httpMethod == HttpMethod.DELETE) {
                return new HttpDelete();
            }
            if (httpMethod == HttpMethod.PATCH) {
                return new HttpPatch();
            }
            if (httpMethod == HttpMethod.HEAD) {
                return new HttpHead();
            }
            throw new UnsupportedOperationException("Method " + (Object)((Object)httpMethod) + " is not supported by apache http-client");
        }
    }
}

