/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons;

import com.github.mjeanroy.junit.servers.commons.Mapper;
import com.github.mjeanroy.junit.servers.commons.Predicate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> String join(Iterable<T> values, String separator) {
        if (values == null) {
            return null;
        }
        String sep = separator == null ? "" : separator;
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (T value : values) {
            if (!first) {
                sb.append(sep);
            }
            sb.append(value == null ? null : value.toString());
            first = false;
        }
        return sb.toString();
    }

    public static <T, U> List<U> map(Collection<T> inputs, Mapper<T, U> mapper) {
        if (inputs == null) {
            return null;
        }
        ArrayList<U> outputs = new ArrayList<U>(inputs.size());
        for (T input : inputs) {
            outputs.add(mapper.apply(input));
        }
        return outputs;
    }

    public static <T> List<T> concat(List<T> inputs, T newValue) {
        ArrayList<T> outputs = new ArrayList<T>(inputs.size() + 1);
        outputs.addAll(inputs);
        outputs.add(newValue);
        return outputs;
    }

    static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        ArrayList<T> results = new ArrayList<T>();
        for (T current : list) {
            if (!predicate.apply(current)) continue;
            results.add(current);
        }
        return results;
    }
}

