/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons;

import com.github.mjeanroy.junit.servers.commons.CollectionUtils;
import com.github.mjeanroy.junit.servers.commons.Predicate;
import com.github.mjeanroy.junit.servers.exceptions.ReflectionException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class ReflectionUtils {
    private static final Predicate<Field> STATIC_FIELD_PREDICATE = new Predicate<Field>(){

        @Override
        public boolean apply(Field field) {
            return Modifier.isStatic(field.getModifiers());
        }
    };
    private static final Predicate<Method> STATIC_METHOD_PREDICATE = new Predicate<Method>(){

        @Override
        public boolean apply(Method object) {
            return Modifier.isStatic(object.getModifiers());
        }
    };

    private ReflectionUtils() {
    }

    public static List<Field> findAllFields(Class<?> type) {
        LinkedList<Field> fields = new LinkedList<Field>();
        if (type != null) {
            Collections.addAll(fields, type.getDeclaredFields());
            if (type.getSuperclass() != null) {
                fields.addAll(ReflectionUtils.findAllFields(type.getSuperclass()));
            }
        }
        return fields;
    }

    private static List<Field> findStaticFields(Class<?> type) {
        return CollectionUtils.filter(Arrays.asList(type.getDeclaredFields()), STATIC_FIELD_PREDICATE);
    }

    private static List<Method> findStaticMethods(Class<?> type) {
        return CollectionUtils.filter(Arrays.asList(type.getDeclaredMethods()), STATIC_METHOD_PREDICATE);
    }

    public static List<Field> findStaticFieldsAnnotatedWith(Class<?> type, Class<? extends Annotation> klass) {
        List<Field> fields = ReflectionUtils.findStaticFields(type);
        return CollectionUtils.filter(fields, new FieldAnnotatedWithPredicate(klass));
    }

    public static List<Method> findStaticMethodsAnnotatedWith(Class<?> type, Class<? extends Annotation> klass) {
        List<Method> methods = ReflectionUtils.findStaticMethods(type);
        return CollectionUtils.filter(methods, new MethodAnnotatedWithPredicate(klass));
    }

    public static void setter(Object instance, Field field, Object value) {
        boolean forceAccess = false;
        try {
            if (!field.isAccessible()) {
                forceAccess = true;
                field.setAccessible(true);
            }
            field.set(instance, value);
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        finally {
            if (forceAccess) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> T getter(Field field) {
        return ReflectionUtils.getter(null, field);
    }

    public static <T> T getter(Object target, Field field) {
        boolean forceAccess = false;
        try {
            if (!field.isAccessible()) {
                field.setAccessible(true);
                forceAccess = true;
            }
            Object object = field.get(target);
            return (T)object;
        }
        catch (IllegalAccessException ex) {
            throw new ReflectionException(ex);
        }
        finally {
            if (forceAccess) {
                field.setAccessible(false);
            }
        }
    }

    public static <T> T invoke(Method method) {
        boolean forceAccess = false;
        try {
            if (!method.isAccessible()) {
                method.setAccessible(true);
                forceAccess = true;
            }
            Object object = method.invoke(null, new Object[0]);
            return (T)object;
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new ReflectionException(ex);
        }
        finally {
            if (forceAccess) {
                method.setAccessible(false);
            }
        }
    }

    private static class MethodAnnotatedWithPredicate
    implements Predicate<Method> {
        private final Class<? extends Annotation> annotationKlass;

        private MethodAnnotatedWithPredicate(Class<? extends Annotation> annotationKlass) {
            this.annotationKlass = annotationKlass;
        }

        @Override
        public boolean apply(Method method) {
            return method.isAnnotationPresent(this.annotationKlass);
        }
    }

    private static class FieldAnnotatedWithPredicate
    implements Predicate<Field> {
        private final Class<? extends Annotation> annotationKlass;

        private FieldAnnotatedWithPredicate(Class<? extends Annotation> annotationKlass) {
            this.annotationKlass = annotationKlass;
        }

        @Override
        public boolean apply(Field field) {
            return field.isAnnotationPresent(this.annotationKlass);
        }
    }
}

