/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.annotations.TestHttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientStrategy;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.commons.ReflectionUtils;
import com.github.mjeanroy.junit.servers.engine.AbstractAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.AnnotationHandler;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.reflect.Field;

class HttpClientAnnotationHandler
extends AbstractAnnotationHandler {
    private final EmbeddedServer<?> server;

    static AnnotationHandler newHttpClientAnnotationHandler(EmbeddedServer<?> server) {
        return new HttpClientAnnotationHandler(Preconditions.notNull(server, "server"));
    }

    private HttpClientAnnotationHandler(EmbeddedServer<?> server) {
        super(TestHttpClient.class);
        this.server = server;
    }

    @Override
    public void before(Object target, Field field) {
        TestHttpClient httpClient = field.getAnnotation(TestHttpClient.class);
        HttpClientStrategy strategy = httpClient.strategy();
        ReflectionUtils.setter(target, field, strategy.build(this.server));
    }

    @Override
    public void after(Object target, Field field) {
        HttpClient httpClient = (HttpClient)ReflectionUtils.getter(target, field);
        httpClient.destroy();
        ReflectionUtils.setter(target, field, null);
    }
}

