/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.annotations.TestServerConfiguration;
import com.github.mjeanroy.junit.servers.commons.ReflectionUtils;
import com.github.mjeanroy.junit.servers.exceptions.ServerImplMissingException;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServerProvider;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public final class Servers {
    private Servers() {
    }

    public static EmbeddedServer<?> instantiate(Class<?> klass) {
        Object configuration = Servers.findConfiguration(klass);
        return Servers.instantiate(configuration);
    }

    public static EmbeddedServer<?> instantiate(AbstractConfiguration configuration) {
        ServiceLoader<EmbeddedServerProvider> serviceProviders = ServiceLoader.load(EmbeddedServerProvider.class);
        ArrayList<EmbeddedServerProvider> coreServerProviders = new ArrayList<EmbeddedServerProvider>();
        ArrayList<EmbeddedServerProvider> customServerProviders = new ArrayList<EmbeddedServerProvider>();
        for (EmbeddedServerProvider provider : serviceProviders) {
            if (provider.getClass().getName().startsWith("com.github.mjeanroy.junit.servers")) {
                coreServerProviders.add(provider);
                continue;
            }
            customServerProviders.add(provider);
        }
        if (coreServerProviders.isEmpty() && customServerProviders.isEmpty()) {
            throw new ServerImplMissingException();
        }
        if (customServerProviders.isEmpty()) {
            return Servers.instantiate((EmbeddedServerProvider)coreServerProviders.get(0), configuration);
        }
        if (customServerProviders.size() > 1) {
            throw new ServerImplMissingException();
        }
        return Servers.instantiate((EmbeddedServerProvider)coreServerProviders.get(0), configuration);
    }

    private static <T extends AbstractConfiguration> EmbeddedServer<T> instantiate(EmbeddedServerProvider<T> provider, T configuration) {
        return configuration == null ? provider.instantiate() : provider.instantiate(configuration);
    }

    public static <T extends AbstractConfiguration> T findConfiguration(Class<?> klass) {
        List<Method> methods = ReflectionUtils.findStaticMethodsAnnotatedWith(klass, TestServerConfiguration.class);
        if (!methods.isEmpty()) {
            return (T)((AbstractConfiguration)ReflectionUtils.invoke(methods.get(0)));
        }
        List<Field> fields = ReflectionUtils.findStaticFieldsAnnotatedWith(klass, TestServerConfiguration.class);
        if (!fields.isEmpty()) {
            return (T)((AbstractConfiguration)ReflectionUtils.getter(fields.get(0)));
        }
        return null;
    }
}

