/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.jupiter;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.engine.AnnotationsHandlerTestLifeCycleAdapter;
import com.github.mjeanroy.junit.servers.engine.EmbeddedServerTestLifeCycleAdapter;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.jupiter.ConfigurationResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.EmbeddedServerParameterResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.HttpClientParameterResolverFunction;
import com.github.mjeanroy.junit.servers.jupiter.ParameterResolverFunction;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class JunitServerExtension
implements BeforeAllCallback,
AfterAllCallback,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{JunitServerExtension.class.getName()});
    private static final String SERVER_ADAPTER_KEY = "serverAdapter";
    private static final String SERVER_ADAPTER_STATIC_MODE = "serverAdapterMode";
    private static final String ANNOTATIONS_ADAPTER_KEY = "annotationsAdapter";
    private static final Map<Class<?>, ParameterResolverFunction> RESOLVERS = new HashMap<Class<?>, ParameterResolverFunction>(){
        {
            this.put(EmbeddedServer.class, EmbeddedServerParameterResolverFunction.getInstance());
            this.put(AbstractConfiguration.class, ConfigurationResolverFunction.getInstance());
            this.put(HttpClient.class, HttpClientParameterResolverFunction.getInstance());
        }
    };
    private final EmbeddedServer<?> server;
    private final AbstractConfiguration configuration;

    public JunitServerExtension() {
        this.server = null;
        this.configuration = null;
    }

    public JunitServerExtension(EmbeddedServer<?> server) {
        this.server = Preconditions.notNull(server, "server");
        this.configuration = null;
    }

    public JunitServerExtension(AbstractConfiguration configuration) {
        this.server = null;
        this.configuration = configuration;
    }

    public void beforeAll(ExtensionContext context) {
        this.registerEmbeddedServer(context, true);
    }

    public void afterAll(ExtensionContext context) {
        this.unregisterEmbeddedServer(context, true);
    }

    public void beforeEach(ExtensionContext context) {
        EmbeddedServerTestLifeCycleAdapter serverAdapter = JunitServerExtension.findEmbeddedServerAdapterInStore(context);
        if (serverAdapter == null) {
            serverAdapter = this.registerEmbeddedServer(context, false);
        }
        EmbeddedServer<?> server = serverAdapter.getServer();
        Object configuration = server.getConfiguration();
        AnnotationsHandlerTestLifeCycleAdapter annotationsAdapter = new AnnotationsHandlerTestLifeCycleAdapter(server, (AbstractConfiguration)configuration);
        annotationsAdapter.beforeEach(context.getRequiredTestInstance());
        JunitServerExtension.putAnnotationsHandlerAdapterInStore(context, annotationsAdapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterEach(ExtensionContext context) {
        try {
            Object target = context.getRequiredTestInstance();
            AnnotationsHandlerTestLifeCycleAdapter annotationsAdapter = JunitServerExtension.findAnnotationsHandlerAdapterInStore(context);
            annotationsAdapter.afterEach(target);
        }
        finally {
            this.unregisterEmbeddedServer(context, false);
            JunitServerExtension.removeAnnotationsHandlerAdapterFromStore(context);
        }
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Class<?> parameterClass = parameter.getType();
        if (RESOLVERS.containsKey(parameterClass)) {
            return true;
        }
        for (Class<?> klass : RESOLVERS.keySet()) {
            if (!klass.isAssignableFrom(parameterClass)) continue;
            return true;
        }
        return false;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        Parameter parameter = parameterContext.getParameter();
        Class<?> parameterClass = parameter.getType();
        EmbeddedServerTestLifeCycleAdapter serverAdapter = JunitServerExtension.findEmbeddedServerAdapterInStore(extensionContext);
        if (RESOLVERS.containsKey(parameterClass)) {
            return RESOLVERS.get(parameterClass).resolve(parameterContext, serverAdapter);
        }
        for (Class<?> klass : RESOLVERS.keySet()) {
            if (!klass.isAssignableFrom(parameterClass)) continue;
            return RESOLVERS.get(klass).resolve(parameterContext, serverAdapter);
        }
        return null;
    }

    protected EmbeddedServer<?> instantiateServer(Class<?> testClass, AbstractConfiguration configuration) {
        return configuration == null ? Servers.instantiate(testClass) : Servers.instantiate(configuration);
    }

    private EmbeddedServerTestLifeCycleAdapter registerEmbeddedServer(ExtensionContext context, boolean staticMode) {
        Class testClass = context.getRequiredTestClass();
        EmbeddedServer<?> server = this.server == null ? this.instantiateServer(testClass, this.configuration) : this.server;
        EmbeddedServerTestLifeCycleAdapter serverAdapter = new EmbeddedServerTestLifeCycleAdapter(server);
        serverAdapter.beforeAll();
        JunitServerExtension.putEmbeddedServerAdapterInStore(context, serverAdapter, staticMode);
        return serverAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterEmbeddedServer(ExtensionContext context, boolean staticMode) {
        boolean registeredAsStatic = (Boolean)JunitServerExtension.findInStore(context, SERVER_ADAPTER_STATIC_MODE);
        if (registeredAsStatic == staticMode) {
            try {
                EmbeddedServerTestLifeCycleAdapter serverAdapter = JunitServerExtension.findEmbeddedServerAdapterInStore(context);
                serverAdapter.afterAll();
            }
            finally {
                JunitServerExtension.removeEmbeddedServerAdapterFromStore(context);
            }
        }
    }

    private static EmbeddedServerTestLifeCycleAdapter findEmbeddedServerAdapterInStore(ExtensionContext context) {
        return (EmbeddedServerTestLifeCycleAdapter)JunitServerExtension.findInStore(context, SERVER_ADAPTER_KEY);
    }

    private static void putEmbeddedServerAdapterInStore(ExtensionContext context, EmbeddedServerTestLifeCycleAdapter serverAdapter, boolean staticMode) {
        JunitServerExtension.putInStore(context, SERVER_ADAPTER_KEY, serverAdapter);
        JunitServerExtension.putInStore(context, SERVER_ADAPTER_STATIC_MODE, staticMode);
    }

    private static void removeEmbeddedServerAdapterFromStore(ExtensionContext context) {
        JunitServerExtension.removeFromStore(context, SERVER_ADAPTER_KEY);
        JunitServerExtension.removeFromStore(context, SERVER_ADAPTER_STATIC_MODE);
    }

    private static AnnotationsHandlerTestLifeCycleAdapter findAnnotationsHandlerAdapterInStore(ExtensionContext context) {
        return (AnnotationsHandlerTestLifeCycleAdapter)JunitServerExtension.findInStore(context, ANNOTATIONS_ADAPTER_KEY);
    }

    private static void putAnnotationsHandlerAdapterInStore(ExtensionContext context, AnnotationsHandlerTestLifeCycleAdapter annotationsHandlerAdapter) {
        JunitServerExtension.putInStore(context, ANNOTATIONS_ADAPTER_KEY, annotationsHandlerAdapter);
    }

    private static void removeAnnotationsHandlerAdapterFromStore(ExtensionContext context) {
        JunitServerExtension.removeFromStore(context, ANNOTATIONS_ADAPTER_KEY);
    }

    private static <T> void putInStore(ExtensionContext context, String name, T value) {
        JunitServerExtension.getStore(context).put((Object)name, value);
    }

    private static <T> T findInStore(ExtensionContext context, String name) {
        return (T)JunitServerExtension.getStore(context).get((Object)name);
    }

    private static void removeFromStore(ExtensionContext context, String name) {
        JunitServerExtension.getStore(context).remove((Object)name);
    }

    private static ExtensionContext.Store getStore(ExtensionContext extensionContext) {
        return extensionContext.getStore(NAMESPACE);
    }
}

