/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.client.Cookie;
import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class HttpClientConfiguration {
    private static final boolean DEFAULT_FOLLOW_REDIRECT = true;
    private static final HttpClientConfiguration DEFAULT_CONFIGURATION = new Builder().build();
    private final Map<String, HttpHeader> defaultHeaders;
    private final List<Cookie> defaultCookies;
    private final boolean followRedirect;

    public static HttpClientConfiguration defaultConfiguration() {
        return DEFAULT_CONFIGURATION;
    }

    private HttpClientConfiguration(boolean followRedirect, Map<String, HttpHeader> defaultHeaders, List<Cookie> defaultCookies) {
        this.followRedirect = followRedirect;
        this.defaultHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, HttpHeader>(defaultHeaders));
        this.defaultCookies = Collections.unmodifiableList(new ArrayList<Cookie>(defaultCookies));
    }

    public Map<String, HttpHeader> getDefaultHeaders() {
        return this.defaultHeaders;
    }

    public List<Cookie> getDefaultCookies() {
        return this.defaultCookies;
    }

    public boolean isFollowRedirect() {
        return this.followRedirect;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpClientConfiguration) {
            HttpClientConfiguration c = (HttpClientConfiguration)o;
            return this.followRedirect == c.followRedirect && Objects.equals(this.defaultHeaders, c.defaultHeaders) && Objects.equals(this.defaultCookies, c.defaultCookies);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.followRedirect, this.defaultHeaders, this.defaultCookies);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("followRedirect", this.followRedirect).append("defaultHeaders", this.defaultHeaders).append("defaultCookies", this.defaultCookies).build();
    }

    public static class Builder {
        private boolean followRedirect = true;
        private final Map<String, HttpHeader> defaultHeaders = new LinkedHashMap<String, HttpHeader>();
        private final List<Cookie> defaultCookies = new ArrayList<Cookie>();

        public Builder addDefaultHeader(HttpHeader header) {
            Preconditions.notNull(header, "header");
            this.defaultHeaders.put(header.getName(), header);
            return this;
        }

        public Builder addDefaultHeader(String name, String value) {
            return this.addDefaultHeader(HttpHeader.header(name, value));
        }

        public Builder addDefaultCookie(Cookie cookie) {
            Preconditions.notNull(cookie, "cookie");
            this.defaultCookies.add(cookie);
            return this;
        }

        public Builder addDefaultCookie(String name, String value) {
            return this.addDefaultCookie(Cookies.cookie(name, value));
        }

        public Builder enableFollowRedirect() {
            this.followRedirect = true;
            return this;
        }

        public Builder disableFollowRedirect() {
            this.followRedirect = false;
            return this;
        }

        public HttpClientConfiguration build() {
            return new HttpClientConfiguration(this.followRedirect, this.defaultHeaders, this.defaultCookies);
        }
    }
}

