/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.Strings;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class HttpHeader {
    private static final String HEADER_SEPARATOR = ",";
    private final String name;
    private final List<String> values;

    public static HttpHeader header(String name, String value) {
        return HttpHeader.of(name, value);
    }

    public static HttpHeader header(String name, Collection<String> values) {
        return HttpHeader.of(name, values);
    }

    public static HttpHeader of(String name, String value) {
        return new HttpHeader(name, Collections.singletonList(value));
    }

    public static HttpHeader of(String name, Collection<String> values) {
        return new HttpHeader(name, values);
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    private HttpHeader(String name, Collection<String> values) {
        this.name = Preconditions.notBlank(name, "name").trim();
        this.values = new ArrayList<String>(values.size());
        for (String val : Preconditions.notEmpty(values, "values")) {
            this.values.add(Preconditions.notNull(val, "value"));
        }
    }

    public String getName() {
        return this.name;
    }

    public List<String> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    public String getFirstValue() {
        return this.values.get(0);
    }

    public String getLastValue() {
        return this.values.get(this.values.size() - 1);
    }

    public String serializeValues() {
        return String.join((CharSequence)HEADER_SEPARATOR, this.values);
    }

    public String serialize() {
        return this.name + ": " + this.serializeValues();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpHeader) {
            HttpHeader h = (HttpHeader)o;
            return Objects.equals(Strings.toLowerCase(this.name), Strings.toLowerCase(h.name)) && Objects.equals(this.values, h.values);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(Strings.toLowerCase(this.name), this.values);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("name", this.name).append("values", this.values).build();
    }

    public static class Builder {
        private final String name;
        private final List<String> values;

        private Builder(String name) {
            this.name = Preconditions.notNull(name, "Http Header name must be defined");
            this.values = new ArrayList<String>();
        }

        public Builder addValue(String value) {
            this.values.add(value);
            return this;
        }

        public HttpHeader build() {
            return HttpHeader.header(this.name, this.values);
        }
    }
}

