/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl;

import com.github.mjeanroy.junit.servers.client.Cookie;
import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpRequestBody;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.commons.lang.Dates;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.exceptions.HttpClientException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpRequest
implements HttpRequest {
    private static final String DEFAULT_BOUNDARIES = "---------------------------974767299852498929531610575";
    private final HttpUrl endpoint;
    private final HttpMethod method;
    protected final Map<String, HttpParameter> queryParams;
    protected HttpRequestBody body;
    protected final List<Cookie> cookies;
    protected final Map<String, HttpHeader> headers;

    protected AbstractHttpRequest(HttpUrl endpoint, HttpMethod method) {
        this.endpoint = Preconditions.notNull(endpoint, "endpoint");
        this.method = Preconditions.notNull(method, "method");
        this.queryParams = new LinkedHashMap<String, HttpParameter>();
        this.headers = new LinkedHashMap<String, HttpHeader>();
        this.cookies = new ArrayList<Cookie>(10);
    }

    @Override
    public HttpUrl getEndpoint() {
        return this.endpoint;
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public HttpRequest addHeader(String name, String value) {
        Preconditions.notBlank(name, "name");
        Preconditions.notNull(value, "value");
        return this.addHeader(HttpHeader.header(name, value));
    }

    @Override
    public HttpRequest addHeader(HttpHeader header) {
        Preconditions.notNull(header, "header");
        this.headers.put(header.getName(), header);
        return this;
    }

    @Override
    public HttpRequest asXmlHttpRequest() {
        return this.addHeader("X-Requested-With", "XMLHttpRequest");
    }

    @Override
    public HttpRequest acceptLanguage(String lang) {
        return this.addHeader("Accept-Language", Preconditions.notBlank(lang, "lang"));
    }

    @Override
    public HttpRequest addAcceptEncoding(String encoding) {
        return this.addHeader("Accept-Encoding", Preconditions.notBlank(encoding, "encoding"));
    }

    @Override
    public HttpRequest acceptGzip() {
        return this.addAcceptEncoding("gzip, deflate");
    }

    @Override
    public HttpRequest addOrigin(String origin) {
        return this.addHeader("Origin", Preconditions.notBlank(origin, "origin"));
    }

    @Override
    public HttpRequest addReferer(String referer) {
        return this.addHeader("Referer", Preconditions.notBlank(referer, "referer"));
    }

    @Override
    public HttpRequest addIfNoneMatch(String etag) {
        return this.addHeader("If-None-Match", Preconditions.notBlank(etag, "etag"));
    }

    @Override
    public HttpRequest addIfMatch(String etag) {
        return this.addHeader("If-Match", Preconditions.notBlank(etag, "etag"));
    }

    @Override
    public HttpRequest addIfModifiedSince(Date date) {
        String value = Dates.format(Preconditions.notNull(date, "date"), "EEE, dd MMM yyyy HH:mm:ss zzz");
        return this.addHeader("If-Modified-Since", value);
    }

    @Override
    public HttpRequest addIfUnmodifiedSince(Date date) {
        String value = Dates.format(Preconditions.notNull(date, "date"), "EEE, dd MMM yyyy HH:mm:ss zzz");
        return this.addHeader("If-Unmodified-Since", value);
    }

    @Override
    public HttpRequest withUserAgent(String userAgent) {
        return this.addHeader("User-Agent", Preconditions.notBlank(userAgent, "userAgent"));
    }

    @Override
    public HttpRequest asJson() {
        return this.addHeader("Content-Type", "application/json");
    }

    @Override
    public HttpRequest asXml() {
        return this.addHeader("Content-Type", "application/xml");
    }

    @Override
    public HttpRequest asFormUrlEncoded() {
        return this.addHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    @Override
    public HttpRequest addQueryParam(String name, String value) {
        return this.addQueryParams(HttpParameter.param(name, value), new HttpParameter[0]);
    }

    @Override
    public HttpRequest addQueryParams(HttpParameter parameter, HttpParameter ... parameters) {
        Preconditions.notNull(parameter, "parameter");
        this.queryParams.put(parameter.getName(), parameter);
        if (parameters != null) {
            for (HttpParameter p : parameters) {
                Preconditions.notNull(p, "parameter");
                this.queryParams.put(p.getName(), p);
            }
        }
        return this;
    }

    @Override
    public HttpRequest setBody(HttpRequestBody body) {
        Preconditions.notNull(body, "body");
        if (!this.getMethod().isBodyAllowed()) {
            throw new UnsupportedOperationException("Http method " + (Object)((Object)this.getMethod()) + " does not support request body");
        }
        this.body = body;
        return this;
    }

    @Override
    public HttpRequest acceptJson() {
        return this.addHeader("Accept", "application/json");
    }

    @Override
    public HttpRequest acceptXml() {
        return this.addHeader("Accept", "application/xml");
    }

    @Override
    public HttpRequest addXHttpMethodOverride(String method) {
        return this.addHeader("X-Http-Method-Override", Preconditions.notBlank(method, "method"));
    }

    @Override
    public HttpRequest addCsrfToken(String token) {
        return this.addHeader("X-Csrf-Token", Preconditions.notBlank(token, "token"));
    }

    @Override
    public HttpRequest overridePut() {
        return this.addXHttpMethodOverride(HttpMethod.PUT.getVerb());
    }

    @Override
    public HttpRequest overrideDelete() {
        return this.addXHttpMethodOverride(HttpMethod.DELETE.getVerb());
    }

    @Override
    public HttpRequest addCookie(Cookie cookie) {
        Preconditions.notNull(cookie, "cookie");
        this.cookies.add(cookie);
        return this;
    }

    @Override
    public HttpRequest addCookie(String name, String value) {
        Preconditions.notBlank(name, "name");
        Preconditions.notNull(value, "value");
        return this.addCookie(Cookies.cookie(name, value));
    }

    @Override
    public HttpResponse execute() {
        try {
            return this.doExecute();
        }
        catch (Exception ex) {
            throw new HttpClientException(ex);
        }
    }

    @Override
    public HttpResponse executeJson() {
        return this.asJson().acceptJson().execute();
    }

    @Override
    public HttpResponse executeXml() {
        return this.asXml().acceptXml().execute();
    }

    protected boolean hasBody() {
        return this.body != null;
    }

    protected abstract HttpResponse doExecute() throws Exception;
}

