/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpResponse;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class DefaultHttpResponse
extends AbstractHttpResponse
implements HttpResponse {
    private final int status;
    private final String body;
    private final Map<String, HttpHeader> headers;

    public static DefaultHttpResponse of(long duration, int status, String body, Collection<HttpHeader> headers) {
        return new DefaultHttpResponse(duration, status, body, headers);
    }

    private DefaultHttpResponse(long duration, int status, String body, Collection<HttpHeader> headers) {
        super(duration);
        this.status = status;
        this.body = body;
        this.headers = new LinkedHashMap<String, HttpHeader>();
        for (HttpHeader header : headers) {
            this.headers.put(header.getName().toLowerCase(), header);
        }
    }

    @Override
    public int status() {
        return this.status;
    }

    @Override
    protected String readResponseBody() {
        return this.body;
    }

    @Override
    public Collection<HttpHeader> getHeaders() {
        return this.headers.values();
    }

    @Override
    public HttpHeader getHeader(String name) {
        return this.headers.get(name.toLowerCase());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DefaultHttpResponse) {
            DefaultHttpResponse r = (DefaultHttpResponse)o;
            return super.equals(o) && Objects.equals(this.status, r.status) && Objects.equals(this.body, r.body) && Objects.equals(this.headers, r.headers);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.status, this.body, this.headers);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("duration", this.getRequestDuration()).append("status", this.status).append("body", this.body).append("headers", this.headers).build();
    }

    @Override
    protected boolean canEqual(AbstractHttpResponse o) {
        return o instanceof DefaultHttpResponse;
    }
}

