/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.apache;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpRequest;
import com.github.mjeanroy.junit.servers.client.impl.apache.ApacheHttpResponseFactory;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;

class ApacheHttpRequest
extends AbstractHttpRequest
implements HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpRequest.class);
    private static final ApacheHttpRequestFactory FACTORY = new ApacheHttpRequestFactory();
    private final HttpClient client;

    ApacheHttpRequest(HttpClient client, HttpMethod httpMethod, HttpUrl endpoint) {
        super(endpoint, httpMethod);
        this.client = client;
    }

    @Override
    protected HttpResponse doExecute() throws Exception {
        HttpMethod method = this.getMethod();
        HttpRequestBase httpRequest = FACTORY.create(method);
        httpRequest.setURI(this.createRequestURI());
        this.handleBody(httpRequest);
        this.handleHeaders(httpRequest);
        this.handleCookies(httpRequest);
        long start = System.nanoTime();
        org.apache.http.HttpResponse httpResponse = this.client.execute((HttpUriRequest)httpRequest);
        long duration = System.nanoTime() - start;
        return ApacheHttpResponseFactory.of(httpResponse, duration);
    }

    private void handleBody(HttpRequestBase httpRequest) throws IOException {
        if (!this.hasBody()) {
            log.debug("HTTP Request does not have body, skip.");
            return;
        }
        log.debug("Set HTTP Entity from given body: {}", this.body);
        ContentType contentType = ContentType.getByMimeType((String)this.body.getContentType());
        ByteArrayEntity entity = new ByteArrayEntity(this.body.getBody(), contentType);
        log.debug("Found contentType={} and entity={}", contentType, entity);
        ((HttpEntityEnclosingRequestBase)httpRequest).setEntity((HttpEntity)entity);
        if (this.body.getContentType() != null) {
            httpRequest.setHeader("Content-Type", this.body.getContentType());
        }
    }

    private URI createRequestURI() throws URISyntaxException {
        URI uri = this.getEndpoint().toURI();
        URIBuilder builder = new URIBuilder(uri).setCharset(StandardCharsets.UTF_8);
        for (HttpParameter parameter : this.queryParams.values()) {
            builder.addParameter(parameter.getName(), parameter.getValue());
        }
        return builder.build();
    }

    private void handleHeaders(HttpRequestBase httpRequest) {
        for (HttpHeader header : this.headers.values()) {
            httpRequest.setHeader(header.getName(), header.serializeValues());
        }
    }

    private void handleCookies(HttpRequestBase httpRequest) {
        if (!this.cookies.isEmpty()) {
            httpRequest.addHeader("Cookie", Cookies.serialize(this.cookies));
        }
    }

    private static class ApacheHttpRequestFactory {
        private ApacheHttpRequestFactory() {
        }

        HttpRequestBase create(HttpMethod httpMethod) {
            if (httpMethod == HttpMethod.GET) {
                return new HttpGet();
            }
            if (httpMethod == HttpMethod.POST) {
                return new HttpPost();
            }
            if (httpMethod == HttpMethod.PUT) {
                return new HttpPut();
            }
            if (httpMethod == HttpMethod.DELETE) {
                return new HttpDelete();
            }
            if (httpMethod == HttpMethod.PATCH) {
                return new HttpPatch();
            }
            if (httpMethod == HttpMethod.HEAD) {
                return new HttpHead();
            }
            throw new UnsupportedOperationException("Method " + (Object)((Object)httpMethod) + " is not supported by apache http-client");
        }
    }
}

