/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.async;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.async.AsyncHttpRequest;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;

public class AsyncHttpClient
extends AbstractHttpClient
implements HttpClient {
    private final org.asynchttpclient.AsyncHttpClient client;

    public static AsyncHttpClient defaultAsyncHttpClient(EmbeddedServer<?> server) {
        HttpClientConfiguration configuration = HttpClientConfiguration.defaultConfiguration();
        return AsyncHttpClient.newAsyncHttpClient(configuration, server);
    }

    public static AsyncHttpClient newAsyncHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        DefaultAsyncHttpClientConfig config = new DefaultAsyncHttpClientConfig.Builder().setFollowRedirect(configuration.isFollowRedirect()).build();
        DefaultAsyncHttpClient client = new DefaultAsyncHttpClient((AsyncHttpClientConfig)config);
        return new AsyncHttpClient(configuration, server, (org.asynchttpclient.AsyncHttpClient)client);
    }

    private AsyncHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server, org.asynchttpclient.AsyncHttpClient client) {
        super(configuration, server);
        this.client = Preconditions.notNull(client, "client");
    }

    @Override
    protected HttpRequest buildRequest(HttpMethod httpMethod, HttpUrl endpoint) {
        return new AsyncHttpRequest(this.client, httpMethod, endpoint);
    }

    @Override
    public void doDestroy() throws Exception {
        this.client.close();
    }

    @Override
    public boolean isDestroyed() {
        return this.client.isClosed();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("configuration", this.getConfiguration()).append("server", this.getServer()).append("client", this.client).build();
    }
}

