/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.async;

import com.github.mjeanroy.junit.servers.client.Cookies;
import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpParameter;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpRequest;
import com.github.mjeanroy.junit.servers.client.impl.async.AsyncHttpResponseFactory;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.IOException;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.ListenableFuture;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.Utf8UrlEncoder;

class AsyncHttpRequest
extends AbstractHttpRequest
implements HttpRequest {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpRequest.class);
    private final AsyncHttpClient client;

    AsyncHttpRequest(AsyncHttpClient client, HttpMethod httpMethod, HttpUrl url) {
        super(url, httpMethod);
        this.client = client;
    }

    @Override
    protected HttpResponse doExecute() throws Exception {
        HttpUrl endpoint = this.getEndpoint();
        String scheme = endpoint.getScheme();
        String userInfo = null;
        String host = endpoint.getHost();
        int port = endpoint.getPort();
        String path = Utf8UrlEncoder.encodePath((String)endpoint.getPath());
        String query = null;
        String fragment = null;
        Uri uri = new Uri(scheme, userInfo, host, port, path, query, fragment);
        String method = this.getMethod().getVerb();
        RequestBuilder builder = (RequestBuilder)new RequestBuilder(method, true).setUri(uri);
        this.handleQueryParameters(builder);
        this.handleBody(builder);
        this.handleHeaders(builder);
        this.handleCookies(builder);
        Request request = builder.build();
        ListenableFuture future = this.client.executeRequest(request);
        long start = System.nanoTime();
        Response response = (Response)future.get();
        long duration = System.nanoTime() - start;
        return AsyncHttpResponseFactory.of(response, duration);
    }

    private void handleQueryParameters(RequestBuilder builder) {
        for (HttpParameter p : this.queryParams.values()) {
            builder.addQueryParam(p.getEncodedName(), p.getEncodedValue());
        }
    }

    private void handleBody(RequestBuilder builder) throws IOException {
        if (!this.hasBody()) {
            log.debug("HTTP Request does not have body, skip.");
            return;
        }
        log.debug("Set body to current request builder using: {}", this.body);
        builder.setBody(this.body.getBody());
        if (this.body.getContentType() != null) {
            builder.setHeader((CharSequence)"Content-Type", this.body.getContentType());
        }
    }

    private void handleHeaders(RequestBuilder builder) {
        for (HttpHeader header : this.headers.values()) {
            builder.setHeader((CharSequence)header.getName(), header.getValues());
        }
    }

    private void handleCookies(RequestBuilder builder) {
        if (!this.cookies.isEmpty()) {
            builder.addHeader((CharSequence)"Cookie", Cookies.serialize(this.cookies));
        }
    }
}

