/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.okhttp3;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.okhttp3.OkHttpRequest;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;

public class OkHttpClient
extends AbstractHttpClient
implements HttpClient {
    private final AtomicBoolean destroyed;
    private final okhttp3.OkHttpClient client;

    public static OkHttpClient defaultOkHttpClient(EmbeddedServer<?> server) {
        HttpClientConfiguration configuration = HttpClientConfiguration.defaultConfiguration();
        return OkHttpClient.newOkHttpClient(configuration, server);
    }

    public static OkHttpClient newOkHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        okhttp3.OkHttpClient client = new OkHttpClient.Builder().followRedirects(configuration.isFollowRedirect()).build();
        return new OkHttpClient(configuration, server, client);
    }

    private OkHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server, okhttp3.OkHttpClient client) {
        super(configuration, server);
        this.client = client;
        this.destroyed = new AtomicBoolean(false);
    }

    @Override
    protected HttpRequest buildRequest(HttpMethod httpMethod, HttpUrl endpoint) {
        return new OkHttpRequest(this.client, httpMethod, endpoint);
    }

    @Override
    protected void doDestroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.client.dispatcher().executorService().shutdown();
            this.client.connectionPool().evictAll();
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("configuration", this.getConfiguration()).append("server", this.getServer()).append("client", this.client).append("destroyed", this.destroyed).build();
    }
}

