/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.okhttp3;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpResponse;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import okhttp3.Headers;
import okhttp3.Response;
import okhttp3.ResponseBody;

final class OkHttpResponse
extends AbstractHttpResponse
implements HttpResponse {
    private final Response response;

    OkHttpResponse(Response response, long duration) {
        super(duration);
        this.response = Preconditions.notNull(response, "Response");
    }

    @Override
    public int status() {
        return this.response.code();
    }

    @Override
    protected String readResponseBody() throws IOException {
        ResponseBody body = this.response.body();
        if (body == null) {
            return null;
        }
        return body.string();
    }

    @Override
    public Collection<HttpHeader> getHeaders() {
        Headers headers = this.response.headers();
        int size = headers.size();
        ArrayList<HttpHeader> results = new ArrayList<HttpHeader>(size);
        for (String name : headers.names()) {
            results.add(HttpHeader.header(name, this.response.headers(name)));
        }
        return results;
    }

    @Override
    public HttpHeader getHeader(String name) {
        List values = this.response.headers(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return HttpHeader.header(name, values);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("duration", this.getRequestDuration()).append("response", this.response).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof OkHttpResponse) {
            OkHttpResponse r = (OkHttpResponse)o;
            return super.equals(r) && Objects.equals(this.response, r.response);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.response);
    }

    @Override
    protected boolean canEqual(AbstractHttpResponse o) {
        return o instanceof OkHttpResponse;
    }
}

