/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.io;

import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;

public final class Ios {
    private static final Logger log = LoggerFactory.getLogger(Ios.class);
    public static final byte[] CRLF = Ios.toUtf8Bytes("\r\n");

    private Ios() {
    }

    public static byte[] toUtf8Bytes(String value) {
        if (value == null) {
            return new byte[0];
        }
        return value.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(Path path) throws IOException {
        if (path == null) {
            return new byte[0];
        }
        return Files.readAllBytes(path);
    }

    public static String guessContentType(Path path) {
        if (path == null) {
            return null;
        }
        log.debug("Try to guess content type of path: {}", path);
        try {
            return Files.probeContentType(path);
        }
        catch (IOException ex) {
            log.warn(ex.getMessage(), ex);
            return null;
        }
    }
}

