/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.lang;

public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(String value) {
        return value == null ? "" : value;
    }

    public static boolean isNotEmpty(String value) {
        return value != null && !value.isEmpty();
    }

    static boolean isBlank(String value) {
        if (value == null) {
            return true;
        }
        for (char character : value.toCharArray()) {
            if (Character.isWhitespace(character)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String value) {
        return !Strings.isBlank(value);
    }

    public static String removePrefix(String value, String prefix) {
        if (value == null || prefix == null || prefix.length() > value.length()) {
            return value;
        }
        return value.startsWith(prefix) ? value.substring(prefix.length()) : value;
    }

    public static String toLowerCase(String value) {
        return value == null ? null : value.toLowerCase();
    }
}

