/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons.reflect;

import com.github.mjeanroy.junit.servers.exceptions.ReflectionException;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class Classes {
    private static final Logger log = LoggerFactory.getLogger(Classes.class);

    private Classes() {
    }

    public static boolean isPresent(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static <T> T instantiate(Class<T> klass) {
        boolean wasAccessible = true;
        Constructor<T> ctor = null;
        try {
            ctor = klass.getDeclaredConstructor(new Class[0]);
            wasAccessible = ctor.isAccessible();
            if (!wasAccessible) {
                ctor.setAccessible(true);
            }
            T t = ctor.newInstance(new Object[0]);
            return t;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error(ex.getMessage(), ex);
            throw new ReflectionException(ex);
        }
        finally {
            if (!wasAccessible) {
                ctor.setAccessible(false);
            }
        }
    }
}

