/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.commons.reflect.Annotations;
import com.github.mjeanroy.junit.servers.commons.reflect.Reflections;
import com.github.mjeanroy.junit.servers.engine.AbstractTestRunner;
import com.github.mjeanroy.junit.servers.engine.AnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.ConfigurationAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.HttpClientAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.ServerAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.TestRunner;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class AnnotationsHandlerRunner
extends AbstractTestRunner
implements TestRunner {
    private static final Logger log = LoggerFactory.getLogger(AnnotationsHandlerRunner.class);
    private final List<AnnotationHandler> handlers;

    public AnnotationsHandlerRunner(EmbeddedServer<?> server, AbstractConfiguration configuration) {
        this.handlers = Arrays.asList(ServerAnnotationHandler.newServerAnnotationHandler(server), ConfigurationAnnotationHandler.newConfigurationAnnotationHandler(configuration), HttpClientAnnotationHandler.newHttpClientAnnotationHandler(server));
    }

    @Override
    public void beforeEach(Object target) {
        log.debug("Injecting to test class instance: {}", target);
        this.process(target, true);
    }

    @Override
    public void afterEach(Object target) {
        log.debug("Clearing test class instance: {}", target);
        this.process(target, false);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("handlers", this.handlers).build();
    }

    private void process(Object target, boolean before) {
        List<Field> fields = Reflections.findAllFields(target.getClass());
        for (Field field : fields) {
            for (AnnotationHandler handler : this.handlers) {
                this.processField(target, handler, field, before);
            }
        }
    }

    private void processField(Object target, AnnotationHandler handler, Field field, boolean before) {
        log.debug("Processing field: {}", field);
        Collection<Annotation> annotations = Annotations.findAnnotations(field);
        log.debug("Found annotations on field: {}", annotations);
        for (Annotation annotation : annotations) {
            this.processFieldAnnotation(target, handler, field, before, annotation);
        }
    }

    private void processFieldAnnotation(Object target, AnnotationHandler handler, Field field, boolean before, Annotation annotation) {
        log.debug("Checking for annotation: {}", annotation);
        if (handler.support(annotation)) {
            log.debug("Annotation {} supported by handler: {}", annotation, handler);
            this.processHandlerAnnotation(target, handler, field, before);
        }
    }

    private void processHandlerAnnotation(Object target, AnnotationHandler handler, Field field, boolean before) {
        if (before) {
            handler.before(target, field);
        } else {
            handler.after(target, field);
        }
    }
}

