/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.annotations.TestServerConfiguration;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.commons.reflect.Reflections;
import com.github.mjeanroy.junit.servers.engine.AbstractAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.AnnotationHandler;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import java.lang.reflect.Field;

class ConfigurationAnnotationHandler
extends AbstractAnnotationHandler {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationAnnotationHandler.class);
    private final AbstractConfiguration configuration;

    static <T extends AbstractConfiguration> AnnotationHandler newConfigurationAnnotationHandler(T configuration) {
        return new ConfigurationAnnotationHandler(Preconditions.notNull(configuration, "configuration"));
    }

    private ConfigurationAnnotationHandler(AbstractConfiguration configuration) {
        super(TestServerConfiguration.class);
        this.configuration = configuration;
    }

    @Override
    public void before(Object target, Field field) {
        log.debug("Injecting embedded server configuration to {} # {}", target, field);
        Reflections.setter(target, field, this.configuration);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("annotationKlass", this.getAnnotationKlass()).append("configuration", this.configuration).build();
    }
}

