/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpClientStrategy;
import com.github.mjeanroy.junit.servers.commons.lang.Preconditions;
import com.github.mjeanroy.junit.servers.commons.lang.ToStringBuilder;
import com.github.mjeanroy.junit.servers.engine.AbstractTestRunner;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.engine.TestRunner;
import com.github.mjeanroy.junit.servers.loggers.Logger;
import com.github.mjeanroy.junit.servers.loggers.LoggerFactory;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class EmbeddedServerRunner
extends AbstractTestRunner
implements TestRunner {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedServerRunner.class);
    private final EmbeddedServer<?> server;
    private final Map<HttpClientId, HttpClient> clients;

    public EmbeddedServerRunner() {
        this((AbstractConfiguration)null);
    }

    public EmbeddedServerRunner(AbstractConfiguration configuration) {
        this(Servers.instantiate(configuration));
    }

    public EmbeddedServerRunner(EmbeddedServer<?> server) {
        this.server = Preconditions.notNull(server, "server");
        this.clients = new HashMap<HttpClientId, HttpClient>();
    }

    @Override
    public void beforeAll() {
        this.start();
    }

    @Override
    public void afterAll() {
        this.stop();
    }

    public void start() {
        log.debug("Starting embedded server");
        this.server.start();
    }

    public void stop() {
        this.stopServer();
        this.closeOpenedClients();
    }

    private void stopServer() {
        log.debug("Stopping embedded server");
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpenedClients() {
        log.debug("Closing embedded server HTTP clients");
        Map<HttpClientId, HttpClient> map = this.clients;
        synchronized (map) {
            for (HttpClient client : this.clients.values()) {
                if (client.isDestroyed()) continue;
                client.destroy();
            }
            this.clients.clear();
        }
    }

    public void restart() {
        log.debug("Restarting embedded server");
        this.server.restart();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public String getScheme() {
        return this.server.getScheme();
    }

    public String getHost() {
        return this.server.getHost();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String getPath() {
        return this.server.getPath();
    }

    public String getUrl() {
        return this.server.getUrl();
    }

    public EmbeddedServer<?> getServer() {
        return this.server;
    }

    public HttpClient getClient() {
        return this.getClient(HttpClientConfiguration.defaultConfiguration());
    }

    public HttpClient getClient(HttpClientConfiguration configuration) {
        return this.openClient(HttpClientStrategy.AUTO, configuration);
    }

    public HttpClient getClient(HttpClientStrategy strategy) {
        return this.getClient(strategy, HttpClientConfiguration.defaultConfiguration());
    }

    public HttpClient getClient(HttpClientStrategy strategy, HttpClientConfiguration configuration) {
        return this.openClient(strategy, configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient openClient(HttpClientStrategy strategy, HttpClientConfiguration configuration) {
        log.debug("Opening HTTP client using strategy: {}", (Object)strategy);
        Preconditions.notNull(strategy, "strategy");
        Preconditions.notNull(configuration, "configuration");
        Map<HttpClientId, HttpClient> map = this.clients;
        synchronized (map) {
            HttpClientId id = new HttpClientId(strategy, configuration);
            if (!this.clients.containsKey(id) || this.clients.get(id).isDestroyed()) {
                HttpClient client = strategy.build(configuration, this.server);
                this.clients.put(id, client);
            }
            return this.clients.get(id);
        }
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("server", this.server).append("clients", this.clients).build();
    }

    private static final class HttpClientId {
        private final HttpClientStrategy strategy;
        private final HttpClientConfiguration configuration;

        private HttpClientId(HttpClientStrategy strategy, HttpClientConfiguration configuration) {
            this.strategy = strategy;
            this.configuration = configuration;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof HttpClientId) {
                HttpClientId id = (HttpClientId)o;
                return Objects.equals((Object)this.strategy, (Object)id.strategy) && Objects.equals(this.configuration, id.configuration);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.strategy, this.configuration});
        }

        public String toString() {
            return ToStringBuilder.create(this.getClass()).append("strategy", (Object)this.strategy).append("configuration", this.configuration).build();
        }
    }
}

