/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.junit.rules.ExternalResource;

public class HadoopDFSRule
extends ExternalResource {
    private HdfsConfiguration conf;
    private MiniDFSCluster cluster;
    private FileSystem mfs;
    private FileContext mfc;

    protected HdfsConfiguration createConfiguration() {
        return new HdfsConfiguration();
    }

    public HdfsConfiguration getConfiguration() {
        return this.conf;
    }

    protected void before() throws Throwable {
        this.conf = this.createConfiguration();
        this.cluster = new MiniDFSCluster.Builder((Configuration)this.conf).numDataNodes(3).build();
        this.cluster.waitActive();
        this.mfs = this.cluster.getFileSystem();
        this.mfc = FileContext.getFileContext();
    }

    protected void after() {
        this.cluster.shutdown(true);
    }

    public FileSystem getMfs() {
        return this.mfs;
    }

    public int getNameNodePort() {
        return this.cluster.getNameNodePort();
    }

    public void write(String filename, String content) throws IOException {
        FSDataOutputStream s = this.getMfs().create(new Path(filename));
        s.writeBytes(content);
        s.close();
    }

    public void copyResource(String filename, String resource) throws IOException {
        this.write(filename, IOUtils.toByteArray((URL)((Object)((Object)this)).getClass().getResource(resource)));
    }

    public void write(String filename, byte[] content) throws IOException {
        FSDataOutputStream s = this.getMfs().create(new Path(filename));
        s.write(content);
        s.close();
    }

    public String read(String filename) throws IOException {
        Path p = new Path(filename);
        int size = (int)this.getMfs().getFileStatus(p).getLen();
        FSDataInputStream is = this.getMfs().open(p);
        byte[] content = new byte[size];
        is.readFully(content);
        return new String(content);
    }

    @Deprecated
    public boolean exist(String filename) throws IOException {
        return this.exists(filename);
    }

    public boolean exists(String filename) throws IOException {
        return this.exists(new Path(filename));
    }

    public boolean exists(Path filename) throws IOException {
        try {
            return this.getMfs().listFiles(filename, true).hasNext();
        }
        catch (FileNotFoundException e) {
            return false;
        }
    }
}

