/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.local.main.ServerRunner;
import com.amazonaws.services.dynamodbv2.local.server.DynamoDBProxyServer;
import com.github.mlk.junit.rules.DynamoDbRule;
import com.github.mlk.junit.rules.Helper;
import com.github.mlk.junit.rules.NativeLibraryRule;
import java.util.regex.Pattern;
import org.junit.rules.ExternalResource;

public class HttpDynamoDbRule
extends ExternalResource
implements DynamoDbRule {
    private NativeLibraryRule nativeLibraryRule;
    private DynamoDBProxyServer server;
    private final int defaultPort;
    private final boolean useFakeCreds;
    private int port;

    public HttpDynamoDbRule() {
        this(-1, true);
    }

    public HttpDynamoDbRule(int defaultPort, boolean useFakeCreds) {
        this.defaultPort = defaultPort;
        this.useFakeCreds = useFakeCreds;
        this.nativeLibraryRule = new NativeLibraryRule(Pattern.compile(".*sqlite.*"));
    }

    @Override
    public AmazonDynamoDB getClient() {
        return (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.getEndpoint(), "us-west-2"))).build();
    }

    protected void before() throws Throwable {
        this.nativeLibraryRule.before();
        System.setProperty("sqlite4java.library.path", this.nativeLibraryRule.getNativeLibrariesFolder().toString());
        if (this.useFakeCreds) {
            System.setProperty("aws.accessKeyId", "x");
            System.setProperty("aws.secretKey", "x");
        }
        this.port = this.defaultPort > -1 ? this.defaultPort : Helper.findRandomOpenPortOnAllLocalInterfaces();
        String[] localArgs = new String[]{"-inMemory", "-port", Integer.toString(this.port)};
        this.server = ServerRunner.createServerFromCommandLineArgs((String[])localArgs);
        this.server.start();
    }

    protected void after() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nativeLibraryRule.after();
    }

    public int getPort() {
        return this.port;
    }

    public String getEndpoint() {
        return "http://localhost:" + this.getPort();
    }
}

