/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.local.embedded.DynamoDBEmbedded;
import com.github.mlk.junit.rules.DynamoDbRule;
import com.github.mlk.junit.rules.NativeLibraryRule;
import java.util.regex.Pattern;
import org.junit.rules.ExternalResource;

public class LocalDynamoDbRule
extends ExternalResource
implements DynamoDbRule {
    private AmazonDynamoDB client;
    private final NativeLibraryRule nativeLibraryRule = new NativeLibraryRule(Pattern.compile(".*sqlite.*"));

    @Override
    public AmazonDynamoDB getClient() {
        return this.client;
    }

    protected void before() throws Throwable {
        this.nativeLibraryRule.before();
        System.setProperty("sqlite4java.library.path", this.nativeLibraryRule.getNativeLibrariesFolder().toString());
        this.client = DynamoDBEmbedded.create().amazonDynamoDB();
    }

    protected void after() {
        try {
            this.client.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.nativeLibraryRule.after();
    }
}

