/*
 * Decompiled with CFR 0.152.
 */
package com.github.mlk.junit.rules;

import com.github.mlk.junit.rules.Helper;
import de.flapdoodle.embed.mongo.MongodExecutable;
import de.flapdoodle.embed.mongo.MongodProcess;
import de.flapdoodle.embed.mongo.MongodStarter;
import de.flapdoodle.embed.mongo.config.IMongodConfig;
import de.flapdoodle.embed.mongo.config.MongodConfigBuilder;
import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.distribution.IFeatureAwareVersion;
import de.flapdoodle.embed.mongo.distribution.Version;
import de.flapdoodle.embed.process.config.IExecutableProcessConfig;
import de.flapdoodle.embed.process.runtime.Network;
import org.junit.rules.ExternalResource;

public class MongoRule
extends ExternalResource {
    private MongodExecutable mongodExe;
    private MongodProcess mongod;
    private final int defaultPort;
    private int currentPort;
    private final IFeatureAwareVersion version;

    public MongoRule(int port, IFeatureAwareVersion version) {
        this.defaultPort = port;
        this.version = version;
    }

    public MongoRule() {
        this(-1, (IFeatureAwareVersion)Version.Main.V2_3);
    }

    public void before() throws Exception {
        this.currentPort = this.defaultPort < 0 ? Helper.findRandomOpenPortOnAllLocalInterfaces() : this.defaultPort;
        IMongodConfig mongodConfig = new MongodConfigBuilder().version(this.version).net(new Net("localhost", this.currentPort, Network.localhostIsIPv6())).build();
        MongodStarter runtime = MongodStarter.getDefaultInstance();
        this.mongodExe = (MongodExecutable)runtime.prepare((IExecutableProcessConfig)mongodConfig);
        this.mongod = (MongodProcess)this.mongodExe.start();
    }

    public void after() {
        if (this.mongod != null) {
            this.mongod.stop();
            this.mongodExe.stop();
        }
    }

    public int getPort() {
        return this.currentPort;
    }
}

